
#include "mbed.h"
#include "stdint.h"
#include "project_defines.h"
#include "buttons.h"
#include "electric_valves.h"

/* Object definition */
BusOut valve_control(INSPIRATION_VALVE_IA_PIN, INSPIRATION_VALVE_IB_PIN,
                     INSPIRATION_VALVE_EN_PIN, EXPIRATION_VALVE_IA_PIN,
                     EXPIRATION_VALVE_IB_PIN, EXPIRATION_VALVE_EN_PIN);


/* Function definition*/
void Valves_Initialize(void){
    
    /* Enable both inspiration and expiration valve */
    INSPIRATION_VALVE_STOP();
    INSPIRATION_VALVE_ENABLE();
    
    EXPIRATION_VALVE_STOP();
    EXPIRATION_VALVE_ENABLE();
    
    
    /* Close the inspiration valve */
    
    INSPIRATION_VALVE_CLOSE();
    while(!INSPIRATION_VALVE_IS_CLOSED){
         //Wait until the inspiration valve is closed
    }
    INSPIRATION_VALVE_STOP();

    
    /* CLose the expiration valve */
    
    EXPIRATION_VALVE_OPEN();

    while(!EXPIRATION_VALVE_IS_OPEN){
         //Wait until the inspiration valve is closed
    }
    EXPIRATION_VALVE_STOP();
        
}