#ifndef STEPPER_MOTOR_DRIVER_H_
#define STEPPER_MOTOR_DRIVER_H_

#include "mbed.h"
#include "FastPWM.h"

#define STEPPER_PULSE_DUTY_CYCLE    0.5f
#define STEPPER_MOTOR_TOTAL_STEPS   6000

#define STEPPER_MOTOR_GO_HOME       0
#define STEPPER_MOTOR_GO_AHEAD      0


/* Type definition */

typedef enum{
    Stepper_Stand_By = 0,
    Stepper_Inspiration,
    Stepper_Inspiration_Finish,
    Stepper_Expiration,
    Stepper_Expiration_Finish,
    Stepper_Limit_Sensor_Error    
}Stepper_Driver_State_t;


/* Object declaration */
extern InterruptIn stepper_pulse_feedback;
extern FastPWM stepper_pulse;
extern DigitalOut stepper_en;
extern DigitalOut stepper_dir;


/* Variable declaration */
extern volatile uint8_t stepper_parameters_update_flag;

// Tables for calculations



// These parameters are configurer through the graphic interface */
extern uint32_t inspiration_stepper_pulses_setpoint;
extern float inspiration_stepper_pulse_period;
extern float expiration_stepper_pulse_period;
extern float calibration_stepper_pulse_period;
extern uint32_t volume_in_steps[VOLUME_SETPOINT_INDEX_LIMIT];

// Variables used in every state of the stepper motor driver */
extern volatile uint32_t stepper_pulse_counter;

extern volatile Stepper_Driver_State_t stepper_driver_state;

/* Function declaration */
void Stepper_Driver_Init(void);
void Stepper_Go_Home_Position(void);
void Stepper_Driver_State_Machine(void);
void Stepper_Driver_Pulse_Signal_Update(void);

#endif