
#include "mbed.h"
#include "QEI.h"
#include "stdint.h"
#include "project_defines.h"
#include "encoder_interface.h"


/* Object definition */
QEI rotary_encoder(ENCODER_A_SIGNAL, ENCODER_B_SIGNAL, NC, 624, QEI::X4_ENCODING);


/* Global variables definition */

int8_t past_parameter_selection_index = PARAMETER_SELECTION_INDEX_DEFAULT;

volatile uint8_t parameter_selection_index_change_flag = 0;
int8_t parameter_selection_index = PARAMETER_SELECTION_INDEX_DEFAULT;

volatile uint8_t volume_setpoint_index_change_flag = 0;
int8_t volume_setpoint_index = VOLUME_SETPOINT_INDEX_DEFAULT ;

volatile uint8_t resp_frequency_index_change_flag = 0;
int8_t resp_frequency_index = RESP_FREQUENCY_INDEX_DEFAULT;

volatile uint8_t i_e_ratio_index_change_flag = 0;
int8_t i_e_ratio_index = I_E_RATIO_INDEX_DEFAULT;




void Parameter_Selection_Index_Update(void){
    
    static int8_t previous_parameter_selection_index = PARAMETER_SELECTION_INDEX_DEFAULT;
    int32_t encoder_counter;
    int8_t  valid_step;
    int8_t temp;
    
    encoder_counter = rotary_encoder.getPulses();
    
    if(encoder_counter >= ENCODER_THRESHOLD){
        valid_step = 1;
        rotary_encoder.reset();
    }else if(encoder_counter <= -ENCODER_THRESHOLD){
        valid_step = -1;
        rotary_encoder.reset();
    }else{
        valid_step = 0;
    }
    
    temp = parameter_selection_index + valid_step;
    if(temp < 0){
        parameter_selection_index = PARAMETER_SELECTION_INDEX_LIMIT - 1;
    }else if(temp >= PARAMETER_SELECTION_INDEX_LIMIT){
        parameter_selection_index = 0;
    }else{ 
        parameter_selection_index = temp;
    } 
    
    if(parameter_selection_index != previous_parameter_selection_index){
        parameter_selection_index_change_flag = 1;
    }
    
    past_parameter_selection_index = previous_parameter_selection_index;
    previous_parameter_selection_index = parameter_selection_index;
} 


void Volume_Setpoint_Index_Update(void){
    
    static int8_t previous_volume_setpoint_index = VOLUME_SETPOINT_INDEX_DEFAULT;
    int32_t encoder_counter;
    int8_t  valid_step;
    int8_t temp;
    
    encoder_counter = rotary_encoder.getPulses();
    
    if(encoder_counter >= ENCODER_THRESHOLD){
        valid_step = 1;
        rotary_encoder.reset();
    }else if(encoder_counter <= -ENCODER_THRESHOLD){
        valid_step = -1;
        rotary_encoder.reset();
    }else{
        valid_step = 0;
    }
    
    temp = volume_setpoint_index + valid_step;
    if(temp < 0){
        volume_setpoint_index = 0;
    }else if(temp >= VOLUME_SETPOINT_INDEX_LIMIT){
        volume_setpoint_index = VOLUME_SETPOINT_INDEX_LIMIT - 1;
    }else{ 
        volume_setpoint_index = temp;
    } 
    
    if(volume_setpoint_index != previous_volume_setpoint_index){
        volume_setpoint_index_change_flag = 1;
    }
    previous_volume_setpoint_index = volume_setpoint_index;
} 


void Resp_Frequency_Index_Update(void){
    
    static int8_t previous_resp_frequency_index = RESP_FREQUENCY_INDEX_DEFAULT;
    int32_t encoder_counter;
    int8_t  valid_step;
    int8_t temp;
    
    encoder_counter = rotary_encoder.getPulses();
    
    if(encoder_counter >= ENCODER_THRESHOLD){
        valid_step = 1;
        rotary_encoder.reset();
    }else if(encoder_counter <= -ENCODER_THRESHOLD){
        valid_step = -1;
        rotary_encoder.reset();
    }else{
        valid_step = 0;
    }
    
    temp = resp_frequency_index + valid_step;
    if(temp < 0){
        resp_frequency_index = 0;
    }else if(temp >= RESP_FREQUENCY_INDEX_LIMIT){
        resp_frequency_index = RESP_FREQUENCY_INDEX_LIMIT - 1;
    }else{ 
        resp_frequency_index = temp;
    } 
    
    if(resp_frequency_index != previous_resp_frequency_index){
        resp_frequency_index_change_flag = 1;
    }
    previous_resp_frequency_index = resp_frequency_index;
} 


void I_E_Ratio_Index_Update(void){
    
    static int8_t previous_i_e_ratio_index = I_E_RATIO_INDEX_DEFAULT;
    int32_t encoder_counter;
    int8_t  valid_step;
    int8_t temp;
    
    encoder_counter = rotary_encoder.getPulses();
    
    if(encoder_counter >= ENCODER_THRESHOLD){
        valid_step = 1;
        rotary_encoder.reset();
    }else if(encoder_counter <= -ENCODER_THRESHOLD){
        valid_step = -1;
        rotary_encoder.reset();
    }else{
        valid_step = 0;
    }
    
    temp = i_e_ratio_index + valid_step;
    if(temp < 0){
        i_e_ratio_index = 0;
    }else if(temp >= I_E_RATIO_INDEX_LIMIT){
        i_e_ratio_index = I_E_RATIO_INDEX_LIMIT - 1;
    }else{ 
        i_e_ratio_index = temp;
    } 
    
    if(i_e_ratio_index != previous_i_e_ratio_index){
        i_e_ratio_index_change_flag = 1;
    }
    previous_i_e_ratio_index = i_e_ratio_index;
} 


