/* File inclusion */
#include "mbed.h"
#include "buttons.h"


/* Object definition */
BusIn  buttons(ENTER_SW_PIN, LIMIT_SW_01_PIN,
               INSPIRATION_VALVE_HALL_01_PIN, INSPIRATION_VALVE_HALL_02_PIN,
               EXPIRATION_VALVE_HALL_01_PIN, EXPIRATION_VALVE_HALL_02_PIN);


/* Global variable definition */
volatile uint8_t button_state = 0; // debounced button state (bit == 1: button pressed)
volatile uint8_t button_press = 0; // button press detect



void Buttons_Initialize(void){
    // Enable the pull-up resistors for the buttons and the switch    
}



/****************************************************************
   getButtonPress: check if a button has been pressed. 
   Each pressed key is reported only once
*****************************************************************/

uint8_t Get_Button_Press(uint8_t button_mask){
  __disable_irq();                                 // disable interrupts
  button_mask &= button_press;                     // read button(s)
  button_press ^= button_mask;                     // clear button(s)
  __enable_irq();                                   // enable interrupts     
  return button_mask;
}