
#include "mbed.h"
#include "stdint.h"
#include "project_defines.h"
#include "nextion_interface.h"
#include "encoder_interface.h"
#include "pressure_sensors.h"
#include "stepper_motor_driver.h"
#include "ventilator.h"



/* Object definition */
Serial  nextion_display(NEXTION_DISPLAY_TX_PIN,NEXTION_DISPLAY_RX_PIN);


/* Global variable definition */

uint16_t volume_setpoint_display = VOLUME_SETPOINT_VALUE_DEFAULT;
uint16_t volume_measured_display = 480;
uint8_t resp_frequency_display = RESP_FREQUENCY_VALUE_DEFAULT;
float   inspiration_time_display = INSPIRATION_TIME_VALUE_DEFAULT;
float   expiration_time_display = EXPIRATION_TIME_VALUE_DEFAULT;
uint8_t pressure_measured_display = 16;


uint16_t selection_box_coordinates[3][4]={
                                            {1,1,159,159},
                                            {161,1,319,159},
                                            {321,1,478, 159}
                                            };  

float i_e_ratio_display_table[I_E_RATIO_INDEX_LIMIT][2]={
                                        {1.0,1.0},
                                        {1.0,1.5},
                                        {1.0,2.0},
                                        {1.0,2.5},
                                        {1.0,3.0}
                                        };


/* Function definition */

void Nextion_Interface_Initialize(void){
    /* Configure baud rate */ 
    nextion_display.baud(9600);
    wait(1);
    nextion_display.printf("baud=%d", NEXTION_DISPLAY_BAUD_RATE);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
    wait(1);
    nextion_display.baud(NEXTION_DISPLAY_BAUD_RATE);
    wait(1);

    /* Draw separators for the displayed values */
    nextion_display.printf("line 10,160,190,160,%d", WHITE);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
    nextion_display.printf("line 10,320,190,320,%d", WHITE);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
    nextion_display.printf("line 610,160,790,160,%d", WHITE);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
    nextion_display.printf("line 610,320,790,320,%d", WHITE);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);  
    
    /* Set font color */
    nextion_display.printf("t1.pco=%d", NORMAL_COLOR);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff); 
    nextion_display.printf("t4.pco=%d", NORMAL_COLOR);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
    nextion_display.printf("t7.pco=%d", NORMAL_COLOR);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);

    /* Print default values */
    Volume_Setpoint_Fix();
    Resp_Frequency_Fix();
    I_E_Ratio_Fix();
     
    /* Print initial measured values */ 
    Volume_Display_Update();
    Flow_Display_Update();
    Pressure_Display_Update();
     
} 



void Parameter_Selection_Box_Update(void){
     
     /* Remove the selection box from the previous position */
      switch(past_parameter_selection_index){
            case 0:
                nextion_display.printf("t1.pco=%d", NORMAL_COLOR);
                nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
                break;
            case 1:
                nextion_display.printf("t4.pco=%d", NORMAL_COLOR);
                nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
                break;
            case 2:
                nextion_display.printf("t7.pco=%d", NORMAL_COLOR);
                nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
                break;
            default:
                break;  
                          
      }     
     
     
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }
     
     /* Draw the selection box in the new position */ 
      switch(parameter_selection_index){
            case 0:
                nextion_display.printf("t1.pco=%d", SELECT_COLOR);
                nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
                break;
            case 1:
                nextion_display.printf("t4.pco=%d", SELECT_COLOR);
                nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
                break;
            case 2:
                nextion_display.printf("t7.pco=%d", SELECT_COLOR);
                nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
                break;
            default:
                break;  
      }
      
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }      
          
}  


void Parameter_Selection_Box_Remove(void){
      
      /* Remove the selection box from the current position */

      switch(parameter_selection_index){
            case 0:
                nextion_display.printf("t1.pco=%d", NORMAL_COLOR);
                nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
                break;
            case 1:
                nextion_display.printf("t4.pco=%d", NORMAL_COLOR);
                nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
                break;
            case 2:
                nextion_display.printf("t7.pco=%d", NORMAL_COLOR);
                nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
                break;
            default:
                break;   
      }
      
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }      
               
}    
    
    
    
    
void Volume_Setpoint_Display_Update(void){

    volume_setpoint_display = VOLUME_SETPOINT_MINIMUM_VALUE  + (VOLUME_SETPOINT_STEP*volume_setpoint_index);
    
    /* Print volume value */
    nextion_display.printf("t1.txt=\"%d\"", volume_setpoint_display);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
    
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }
        
} 


void Volume_Setpoint_Fix(void){

    volume_setpoint = volume_setpoint_display;
    stepper_parameters_update_flag = 1;
    
    /* Print volume value */
    nextion_display.printf("t1.txt=\"%d\"", volume_setpoint_display);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
    
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }    
    
    volume_ml = 0.0;
} 


void Resp_Frequency_Display_Update(void){

    resp_frequency_display = 10 + resp_frequency_index;
    
    /* Print frequency value */
    nextion_display.printf("t4.txt=\"%d\"", resp_frequency_display);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
    
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }    
    
}  


void Resp_Frequency_Fix(void){

    resp_frequency = resp_frequency_display;
    stepper_parameters_update_flag = 1;
    
    /* Print frequency value */
    nextion_display.printf("t4.txt=\"%d\"", resp_frequency_display);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
    
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }    
    
}  

void I_E_Ratio_Display_Update(void){
    
    inspiration_time_display = i_e_ratio_display_table[i_e_ratio_index][0];
    expiration_time_display = i_e_ratio_display_table[i_e_ratio_index][1];
    
    /* Print i:e ratio value */
    nextion_display.printf("t7.txt=\"%2.1f : %2.1f\"", inspiration_time_display, expiration_time_display);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff); 
    
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }    
    
}  


void I_E_Ratio_Fix(void){
    
    inspiration_time = inspiration_time_display;
    expiration_time = expiration_time_display;
    stepper_parameters_update_flag = 1;
    
    /* Print i:e ratio value */
    nextion_display.printf("t7.txt=\"%2.1f : %2.1f\"", inspiration_time_display, expiration_time_display);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
    
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }    
    
}  


void Volume_Display_Update(void){
    nextion_display.printf("t11.txt=\"%d\"", (int16_t)(volume_ml * VOLUME_CORRECTION_FACTOR));
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
    
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }
    
}


void Flow_Display_Update(void){
    nextion_display.printf("t14.txt=\"%.2f\"", flow_lpm);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
    
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    } 
    
}

void Pressure_Display_Update(void){
    nextion_display.printf("t15.txt=\"%d\"", (int16_t)(pressure_02_psi * PSI_TO_CMH2O_CONSTANT));
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);

    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }    
    
}


void Nextion_Plot_Volume_Waveform(void){
    
    static uint16_t x_pos_counter = 1, prev_y_pos = (VOLUME_WAVEFORM_Y0 + VOLUME_WAVEFORM_HEIGHT - 1);
    int16_t x_pos, y_pos;
    uint16_t volume_scaled_value;
    
    volume_scaled_value = VOLUME_WAVEFORM_OFFSET + (int16_t)(volume_ml * VOLUME_WAVEFORM_GAIN);
    
    x_pos_counter = x_pos_counter + 1;
    
    if(x_pos_counter >= VOLUME_WAVEFORM_WIDTH){
        nextion_display.printf("fill %d,%d,%d,%d,%d",VOLUME_WAVEFORM_X0,VOLUME_WAVEFORM_Y0,VOLUME_WAVEFORM_WIDTH,VOLUME_WAVEFORM_HEIGHT,WAVEFORM_BACKGROUND_COLOR);
        nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
        x_pos_counter = 1;
        
        /* Read pressure sensors if necessary */ 
        if(read_pressure_sensors_flag){
            Pressure_Sensors_Read();
            Calculate_Flow_From_Pressure();
            Calculate_Volume_From_Flow();
            read_pressure_sensors_flag = 0;
        }       
        
    }
    
    x_pos = VOLUME_WAVEFORM_X0 + x_pos_counter;
    y_pos = VOLUME_WAVEFORM_Y0 + VOLUME_WAVEFORM_HEIGHT - volume_scaled_value - 1;
    
    if(y_pos <= VOLUME_WAVEFORM_Y0){
        y_pos = VOLUME_WAVEFORM_Y0 + 1;
    }else if(y_pos >= (VOLUME_WAVEFORM_Y0 + VOLUME_WAVEFORM_HEIGHT)){
        y_pos = VOLUME_WAVEFORM_Y0 + VOLUME_WAVEFORM_HEIGHT - 1;
    }
    
    nextion_display.printf("line %d,%d,%d,%d,%d",(x_pos - 1), prev_y_pos, x_pos, y_pos, GREEN);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
 
    prev_y_pos = y_pos; 
 
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }

}


void Nextion_Plot_Flow_Waveform(void){
    
    static uint16_t x_pos_counter = 1, prev_y_pos = (FLOW_WAVEFORM_Y0 + FLOW_WAVEFORM_HEIGHT - 1);
    uint16_t x_pos, y_pos;
    uint16_t flow_scaled_value;
    
    flow_scaled_value = FLOW_WAVEFORM_OFFSET + (int16_t)(flow_lpm*FLOW_WAVEFORM_GAIN);
    
    x_pos_counter = x_pos_counter + 1;
    
    if(x_pos_counter >= FLOW_WAVEFORM_WIDTH){
        nextion_display.printf("fill %d,%d,%d,%d,%d",FLOW_WAVEFORM_X0,FLOW_WAVEFORM_Y0,FLOW_WAVEFORM_WIDTH,FLOW_WAVEFORM_HEIGHT,WAVEFORM_BACKGROUND_COLOR);
        nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
        x_pos_counter = 1;
        
        /* Read pressure sensors if necessary */ 
        if(read_pressure_sensors_flag){
            Pressure_Sensors_Read();
            Calculate_Flow_From_Pressure();
            Calculate_Volume_From_Flow();
            read_pressure_sensors_flag = 0;
        }        
        
    }
    
    x_pos = FLOW_WAVEFORM_X0 + x_pos_counter;
    y_pos = FLOW_WAVEFORM_Y0 + FLOW_WAVEFORM_HEIGHT - flow_scaled_value - 1;
    
    
    if(y_pos <= FLOW_WAVEFORM_Y0){
        y_pos = FLOW_WAVEFORM_Y0 + 1;
    }else if(y_pos >= (FLOW_WAVEFORM_Y0 + FLOW_WAVEFORM_HEIGHT)){
        y_pos = FLOW_WAVEFORM_Y0 + FLOW_WAVEFORM_HEIGHT - 1;
    
    }
    
    nextion_display.printf("line %d,%d,%d,%d,%d",(x_pos - 1), prev_y_pos, x_pos, y_pos, YELLOW);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
 
    prev_y_pos = y_pos; 
    
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }    
     
}


void Nextion_Plot_Pressure_Waveform(void){
    
    static uint16_t x_pos_counter = 1, prev_y_pos = (PRESSURE_WAVEFORM_Y0 + PRESSURE_WAVEFORM_HEIGHT - 1);
    uint16_t x_pos, y_pos;
    uint16_t pressure_02_scaled_value;
    
    pressure_02_scaled_value = PRESSURE_WAVEFORM_OFFSET + (uint16_t)(pressure_02_psi * PRESSURE_WAVEFORM_GAIN) ;
    
    x_pos_counter = x_pos_counter + 1;
    
    if(x_pos_counter >= PRESSURE_WAVEFORM_WIDTH){
        nextion_display.printf("fill %d,%d,%d,%d,%d",PRESSURE_WAVEFORM_X0,PRESSURE_WAVEFORM_Y0,PRESSURE_WAVEFORM_WIDTH,PRESSURE_WAVEFORM_HEIGHT,WAVEFORM_BACKGROUND_COLOR);
        nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
        x_pos_counter = 1;
     
        /* Read pressure sensors if necessary */ 
        if(read_pressure_sensors_flag){
            Pressure_Sensors_Read();
            Calculate_Flow_From_Pressure();
            Calculate_Volume_From_Flow();
            read_pressure_sensors_flag = 0;
        }         
        
    }
    
    x_pos = PRESSURE_WAVEFORM_X0 + x_pos_counter;
    y_pos = PRESSURE_WAVEFORM_Y0 + PRESSURE_WAVEFORM_HEIGHT - pressure_02_scaled_value - 1;
    
    
    if(y_pos <= PRESSURE_WAVEFORM_Y0){
        y_pos = PRESSURE_WAVEFORM_Y0 + 1;
    }
    
    nextion_display.printf("line %d,%d,%d,%d,%d",(x_pos - 1), prev_y_pos, x_pos, y_pos, WHITE);
    nextion_display.printf("%c%c%c", 0xff, 0xff, 0xff);
    
    prev_y_pos = y_pos;
    
    /* Read pressure sensors if necessary */ 
    if(read_pressure_sensors_flag){
        Pressure_Sensors_Read();
        Calculate_Flow_From_Pressure();
        Calculate_Volume_From_Flow();
        read_pressure_sensors_flag = 0;
    }     
     
}

