#ifndef BUTTONS_H_
#define BUTTONS_H_

#include "mbed.h"
#include "stdint.h"
#include "project_defines.h" 

/* Object declaration */
extern BusIn  buttons;

/* Global variable declaration */
extern volatile uint8_t button_state; // debounced button state (bit == 1: button pressed)
extern volatile uint8_t button_press; // button press detect

/* Functions declaration */
void Buttons_Initialize(void);
uint8_t Get_Button_Press(uint8_t button_mask);


/***********************************************************************
   buttonDebounce: Check if a button has changed and keeps its new value 
   (HIGH or LOW) for 03 periods of time.
************************************************************************/

static inline void Button_Debounce(void){
    static unsigned char ct0, ct1;
    unsigned char k = 0;

    k = button_state ^ (~buttons);           // button changed ?
    ct1 = (ct0 ^ ct1) & k;                   // reset or count ct1
    ct0 = (~ct0) & k;                        // reset or count ct0
    k &= ct0 & ct1;                          // count until roll over
    button_state ^= k;                       // then toggle debounced state
    button_press |= button_state & k;        // 0->1: button press detect

}


#endif /* BUTTONS_H_ */