
#ifndef PRESSURE_SENSORS_H_
#define PRESSURE_SENSORS_H_

#include "stdint.h"

extern I2C pressure_sensor_01;
extern I2C pressure_sensor_02;

/* Global variable declaration */
extern int32_t pressure_01_bin;
extern int16_t pressure_02_bin;
extern float pressure_01_psi, pressure_02_psi;
extern float flow_lpm, volume_ml;

extern char sensor_read_data_buffer[2]; 

extern volatile uint8_t peak_volume_flag;

/* Function declaration */
void Pressure_Sensors_Initialize(void);
void Pressure_Sensors_Read(void);
void Calculate_Flow_From_Pressure(void);
void Calculate_Volume_From_Flow(void);

#endif