


#ifndef ENCODER_INTERFACE_H_
#define ENCODER_INTERFACE_H_

#include "stdint.h"
#include "QEI.h"

/* Object declaration */
extern QEI rotary_encoder;

/* Global variables declaration */
extern int8_t past_parameter_selection_index;
extern volatile uint8_t parameter_selection_index_change_flag;
extern int8_t parameter_selection_index;
extern volatile uint8_t volume_setpoint_index_change_flag;
extern int8_t volume_setpoint_index;
extern volatile uint8_t resp_frequency_index_change_flag;
extern int8_t resp_frequency_index;
extern volatile uint8_t i_e_ratio_index_change_flag;
extern int8_t i_e_ratio_index;

/* Function declaration */
void Parameter_Selection_Index_Update(void);
void Volume_Setpoint_Index_Update(void);
void Resp_Frequency_Index_Update(void);
void I_E_Ratio_Index_Update(void);


#endif