
#ifndef VENTILATOR_H_
#define VENTILATOR_H_

/* File inclusion */
#include "mbed.h"
#include "stdint.h"
#include "encoder_interface.h"

/* Type definition */
typedef enum {
    Main_Screen_Cursor_Disable = 0,
    Main_Screen_Cursor_Enable = 1,
    Main_Screen_Volume_Setpoint_Adjust = 2,
    Main_Screen_Resp_Frequency_Adjust = 3,
    Main_Screen_I_E_Ratio_Adjust = 4
}Main_Screen_State_t;


/* Object declaration */
extern Ticker ticker_int_1ms;
extern DigitalOut test_pin;

/* Global variable declaration */
extern volatile uint8_t read_pressure_sensors_flag;
extern volatile uint8_t pressure_sensor_display_update_flag;
extern volatile uint8_t pressure_sensor_waveform_update_flag;

extern uint16_t volume_setpoint;
extern uint8_t resp_frequency;
extern float   inspiration_time;
extern float   expiration_time;

extern Main_Screen_State_t main_screen_state;
extern uint8_t first_time_in_state;


/* Function declaration */
void System_Initialize(void);
void Nextion_Encoder_Interaction(void);
void Nextion_Update_Sensor_Values(void);
void Nextion_Update_Waveform_Values(void);
void Ticker_ISR(void); // ISR that is called when the timer reaches the set value

/* Inline functions */
static inline void Encoder_Read(){

        if(main_screen_state == Main_Screen_Cursor_Enable){
            Parameter_Selection_Index_Update();
        }else if(main_screen_state == Main_Screen_Volume_Setpoint_Adjust){
            Volume_Setpoint_Index_Update();
        }else if(main_screen_state == Main_Screen_Resp_Frequency_Adjust){
            Resp_Frequency_Index_Update();
        }else if(main_screen_state == Main_Screen_I_E_Ratio_Adjust){
            I_E_Ratio_Index_Update();
        }else{    
            //Does nothing
        }  
}


#endif