 
//#include "math.h"
#include "mbed.h"
#include "project_defines.h"
#include "stepper_motor_driver.h"
#include "buttons.h"
#include "nextion_interface.h"
#include "FastPWM.h"
#include "ventilator.h"
#include "pressure_sensors.h"
#include "electric_valves.h"

/* Object definition */
InterruptIn stepper_pulse_feedback(STEPPER_PULSE_FEEDBACK_PIN);
FastPWM      stepper_pulse(STEPPER_PULSE_PIN, -1);
DigitalOut  stepper_en(STEPPER_ENABLE_PIN);
DigitalOut  stepper_dir(STEPPER_DIRECTION_PIN);


/* Variable definition */

volatile uint8_t stepper_parameters_update_flag = 0;


// These parameters are configurer through the graphic interface */
uint32_t inspiration_stepper_pulses_setpoint = STEPPER_DRIVER_INSPIRATION_PULSES_DEFAULT ;

float inspiration_stepper_pulse_period = 0.005;
float expiration_stepper_pulse_period = 0.005;
float calibration_stepper_pulse_period = 0.005;


// Volume setpoint (250mL, 300mL, 350ml ... 750ml) expressed in steps
uint32_t volume_in_steps[VOLUME_SETPOINT_INDEX_LIMIT] = {
                                                       70,  //  1600, //250 mL//720//47
                                                       75,  //  1700, //300 mL//765
                                                       80,  //  1800, //350 mL//810
                                                       85,  //  1900, //400 mL//855
                                                       90,  //  2000, //450 mL//900
                                                       95,   //  2100, //500 mL//945
                                                       100,   //  2200, //550 mL//990
                                                       105,   //  2300, //600 mL  //1035  
                                                       110,  //  2400, //650 mL//1080
                                                       115,   //  2500, //700 mL//1125
                                                       120 //  2600  //750 mL//1170
                                                    };  


// Variables used in every state of the stepper motor driver */
volatile uint32_t stepper_pulse_counter = 0;
//volatile uint32_t stepper_ramp_pulse_counter = 0;

// State of the stepper motor
volatile Stepper_Driver_State_t stepper_driver_state = Stepper_Stand_By;

/* Function definition */

/* Initialize the control signals for the stepper */
void Stepper_Driver_Init(void){
    stepper_en = STEPPER_ENABLED;
    stepper_dir = TO_HOME;
    stepper_pulse.period(calibration_stepper_pulse_period);
    stepper_pulse.write(0.0f);
    stepper_pulse_feedback.fall(&Stepper_Driver_Pulse_Signal_Update);
    stepper_driver_state = Stepper_Inspiration_Finish;
    stepper_parameters_update_flag = 1; 
    // Just for testing purposes
    //inspiration_stepper_pulses_setpoint = volume_in_steps[10];
}


void Stepper_Go_Home_Position(void){
   // stepper_driver_state = Stepper_Driver_Home_Ramp;
    
    //while(stepper_driver_state != Stepper_Driver_Stand_By){
      //  Stepper_Driver_State_Machine();
    //} 
}    


void Stepper_Update_Parameters(void){
    
    int8_t stepper_volume_index;
    float total_time, total_time_sec, insp_time_sec, exp_time_sec;
    
    /* Update the value of the volume setpoint (expressed in steps) */
    stepper_volume_index = (volume_setpoint - VOLUME_SETPOINT_MINIMUM_VALUE) / VOLUME_SETPOINT_STEP;
    inspiration_stepper_pulses_setpoint = volume_in_steps[stepper_volume_index];
    
    /* Update the value of the pulse periods in microseconds */
    total_time = inspiration_time + expiration_time;
    total_time_sec = 60.0 / resp_frequency;
    insp_time_sec = (total_time_sec * inspiration_time) / total_time;
    exp_time_sec = (total_time_sec * expiration_time) / total_time;
    
    /* Calculate stepper pulse period for inspiration */
    inspiration_stepper_pulse_period = ((float)insp_time_sec) / ((float)inspiration_stepper_pulses_setpoint);
    /* Calculate stepper pulse period for expiration */
    expiration_stepper_pulse_period = ((float)exp_time_sec) / ((float)inspiration_stepper_pulses_setpoint);

    volume_ml = 0.0;

}



void Stepper_Driver_State_Machine(void){
    
    switch(stepper_driver_state){
          
        case Stepper_Inspiration:    
                    
             if(INSPIRATION_VALVE_IS_OPEN){
                INSPIRATION_VALVE_STOP();
            }
            
             if(EXPIRATION_VALVE_IS_CLOSED){
                EXPIRATION_VALVE_STOP();
            }   
                       
            break;
        // -----------------------------------------------------------------------     
   
        case Stepper_Inspiration_Finish:
            
                stepper_pulse_counter = 0;
                stepper_dir = TO_HOME;
                stepper_pulse.period(expiration_stepper_pulse_period);
                stepper_pulse.write(0.5);        
                stepper_driver_state = Stepper_Expiration;
                INSPIRATION_VALVE_CLOSE();
                EXPIRATION_VALVE_OPEN();       
            break;
        // -----------------------------------------------------------------------         
        case Stepper_Expiration:  
        
            if(peak_volume_flag == 1){// FOr test    
                pressure_sensor_display_update_flag = 1;
                peak_volume_flag = 0;
            } // For test
            
            if(INSPIRATION_VALVE_IS_CLOSED){
                INSPIRATION_VALVE_STOP();
            }
            
             if(EXPIRATION_VALVE_IS_OPEN){
                EXPIRATION_VALVE_STOP();
            }           
                        
             break;
        // -----------------------------------------------------------------------         
        case Stepper_Expiration_Finish:
        
            if(stepper_parameters_update_flag){
                stepper_parameters_update_flag = 0;
                Stepper_Update_Parameters();
            }
                
            stepper_pulse_counter = 0;       
            stepper_dir = TO_AIRBAG;
            stepper_pulse.period(inspiration_stepper_pulse_period);
            stepper_pulse.write(0.5);
            stepper_driver_state = Stepper_Inspiration;         

            pressure_sensor_display_update_flag = 1;
            volume_ml = 0; // Para pruebas

            EXPIRATION_VALVE_CLOSE();
            INSPIRATION_VALVE_OPEN();  

            break;
        // -------------------------------------------------------------------- 
        case Stepper_Limit_Sensor_Error:
            // Stop the system
            stepper_en = STEPPER_DISABLED;
          //  tft->locate(340,VALUES_ROW2_Y_POS);
           // tft->printf("error"); 
            stepper_driver_state = Stepper_Stand_By;
            break;  
         // --------------------------------------------------------------------   
         case Stepper_Stand_By:   
            
            break;
          // --------------------------------------------------------------------    
          default:
          
            break;
    }
}


void Stepper_Driver_Pulse_Signal_Update(void){
  
    // Increment the stepper pulse counter
    stepper_pulse_counter++;
        

    switch(stepper_driver_state){
   
        case Stepper_Inspiration:
            if(stepper_pulse_counter >= inspiration_stepper_pulses_setpoint){
                stepper_driver_state = Stepper_Inspiration_Finish;
                stepper_pulse.write(0.0); 
            }
            break; 
        // --------------------------------------------------------------------      
        case Stepper_Inspiration_Finish:
            break; 
        // --------------------------------------------------------------------  
        case Stepper_Expiration:
            if(buttons & (1 << LIMIT_SW_01)){
                stepper_driver_state = Stepper_Expiration_Finish;
                stepper_pulse.write(0.0);
            }else if(stepper_pulse_counter > STEPPER_DRIVER_MAX_PULSES){ 
                stepper_driver_state = Stepper_Limit_Sensor_Error;
                stepper_pulse.write(0.0);
            }else{
                // Does nothing
            }     
        
            break; 
        // --------------------------------------------------------------------       
        case Stepper_Expiration_Finish:
            break; 
         // --------------------------------------------------------------------
        default:
            break;                               
        }
     
}




 