#include "mbed.h"
#include "stdint.h"
#include "project_defines.h"
#include "buttons.h"
#include "encoder_interface.h"
#include "nextion_interface.h"
#include "stepper_motor_driver.h"
#include "pressure_sensors.h"
#include "ventilator.h"


Serial pc(USBTX, USBRX);

int main(void) {
    
    pc.baud(115200);
    System_Initialize();
    
    wait(1);
    volume_ml = 0;

    while(1){
         
         Nextion_Encoder_Interaction();     
         Stepper_Driver_State_Machine();
         
         if(read_pressure_sensors_flag){
             Pressure_Sensors_Read();
             Calculate_Flow_From_Pressure();
             Calculate_Volume_From_Flow();
             read_pressure_sensors_flag = 0;
         }
         
         //if((stepper_driver_state != Stepper_Inspiration_Finish) && 
            //(stepper_driver_state != Stepper_Expiration_Finish)){
            /* Display sensed values if necessary */    
            if(pressure_sensor_display_update_flag){
               Nextion_Update_Sensor_Values();
               pressure_sensor_display_update_flag = 0;
            }
            /* Plot sensed values if necessary */
            if(pressure_sensor_waveform_update_flag){
                Nextion_Update_Waveform_Values();
                pressure_sensor_waveform_update_flag = 0;
            }  
                 
         //}      
    }
  
    return 0;
}



  





