#include "mbed.h"
#include "TextLCD.h"

Serial slave1(PA_11, PA_12);
Serial slave2(PA_15, PB_7);
Serial bluetooth(PA_2, PA_3);

AnalogIn boton_LCD(A0);
DigitalIn mov(D2);

Ticker lcdTimer, movTimer, sendTimer,alarmDatos;

TextLCD lcd = TextLCD(D8, D9, D4, D5, D6, D7, TextLCD::LCD16x2);

float key_value[6] = {0.05, 0.25, 0.45, 0.70, 0.85, 0.95}; 
int NUM_KEYS = 6;
float key_in;
int key = -1;
int x = 0;
char caracterActual = 'Z';
char password[8] = "AAAA";
char enterPassword [8];
int alarm = 0;


int get_boton(float input);
void lcd_control();
int get_movimiento();
void sendData();        //Ver como se hace y el readData


void sendData(){
    char bufferSlave1[64];
    char bufferSlave2[64];
    char bufferTotal[128];
    
    if(slave1.readable()){
        slave1.gets(bufferSlave1,64);
    }
    if(slave2.readable()){
        slave2.gets(bufferSlave2,64);
    }
    strncpy(bufferTotal, bufferSlave1, sizeof(bufferSlave1));
    strncat(bufferTotal, bufferSlave2,sizeof(bufferSlave2));
    
    wait(0.2f);
    if(bluetooth.writeable()){
        bluetooth.printf("%s",bufferTotal);
    }
}

void sendAlarm(){
    if(slave1.writeable()){
        if(alarm == 1){
            slave1.putc('A');
            wait(0.2);
            if(mov.read() == 1){
                slave1.putc('3');
            }
        }else if(alarm == 0){
            slave1.putc('N');
            }
    }
}

int get_boton(float input){     //Metodo para obtener el boton pulsado en función del valor
  
    int k;
    if (input > key_value[5])  k = -1; //Error en la lectura
     
    else {
        for (k=0; k<NUM_KEYS; k++){
        if(input < key_value[k])    return k;
        }
    }   
    return k;
}

void lcd_control(){
        int i;
        wait(0.2);
        key_in = boton_LCD.read();
        key = get_boton(key_in);
        
        lcd.locate(x,1);
        
        if( key == 0){      //Tecla rigth
            enterPassword[x] = caracterActual;
            x++;
            if(x > 15) x=15;
            lcd.locate(x,1);
            caracterActual = 'A'; 
            lcd.printf("%c",caracterActual);
             
        }
        if ( key == 1){     //Tecla up
            caracterActual++;
            if(caracterActual > 'Z') caracterActual = 'A';
            //pc.printf(caracterActual);
            lcd.printf("%c",caracterActual);
        }
        if(key == 2) {      //Tecla down
            caracterActual--;
            if(caracterActual < 'A') caracterActual = 'Z';
            //pc.printf(caracterActual);
            lcd.printf("%c",caracterActual);
        }
        if(key == 3) {      //Tecla left
            x--;
            if (x<0) x = 0;
            caracterActual = 'Z';
        }
        if(key == 5){       //Tecla select
            enterPassword[x] = caracterActual;
            x = 0;

            if(alarm == 0){
                if(strcmp(password,enterPassword) == 0){
                    alarm = 1;
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Alarma Activada");
                    lcd.locate(0,1);
                }else{
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Pass incorrect");
                    lcd.locate(0,1);
                }
            }else{
                if(strcmp(password,enterPassword) == 0){
                    alarm = 0;
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Alarma Desact");
                    lcd.locate(0,1);
                }else{
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Pass incorrect");
                    lcd.locate(0,1);
                }  
            }
            for(i=0; i<8; i++){
                enterPassword[i] = (char)0;
            }
    }
}

int main(){
    lcd.locate(0,0);
    lcd.printf("Enter password");
    float movimiento;
    while(1){
        lcdTimer.attach(&lcd_control,0.5f);
        sendTimer.attach(&sendData, 1.0f);
        alarmDatos.attach(&sendAlarm, 0.5f);
        wait(1.0f);
    }    
}
