//CÓDIGO 3-B

#include "mbed.h"
#include "stdlib.h"
#include <LiquidCrystal_I2C.h>
#include <iostream>
#include <string>

Serial pc(USBTX, USBRX); // tx, rx

//Los puertos SDA  y SD8 están referenciados en el archivo LiquidCrystal_I2C.cpp
// SDA -> PTC9
// SCL -> PTC8
//                     DIR   TIPO
LiquidCrystal_I2C lcd(0x4E, 16, 2);
I2CSlave slave(I2C_SDA, I2C_SCL);
char addr = 0xA0;

int main()
{
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    
    float x, y, z;
    
    pc.printf("\r\n");
    char buf[16];
    lcd.begin(); // Inicia la LCD
    slave.address(addr);
    slave.frequency (100000);
   
    lcd.clear();
    lcd.print("Datos obtenidos:");
    char msg[] = "Respuesta slave";
    while (1)
    {
        int i = slave.receive();
        switch (i) {
            case I2CSlave::ReadAddressed:
                slave.write(msg, strlen(msg) + 1);
                NVIC_SystemReset();
                break;
            case I2CSlave::WriteGeneral:
                slave.read(buf, 16);
                printf("\rRead General: %s\n", buf);
                break;
            case I2CSlave::WriteAddressed:
                slave.read(buf, 16);
                pc.printf("\rRead Addressed: %s\n", buf);
                
                sscanf(buf, "%f, %f, %f", &x, &y, &z);
                //rled = 1.0f - x; //Encender LED interno
                //gled = 1.0f - y;
                //bled = 1.0f - z;
                
                lcd.setCursor(2, 1);
                lcd.print(buf);
                NVIC_SystemReset();
                break;
        }
        for (int i = 0; i < 16; i++) {
            buf[i] = 0;    // Clear buffer
        }
    }
}