//CÓDIGO 3-A

#include "mbed.h"
#include "MMA8451Q.h"
#include "stdio.h"
#include "stdlib.h"

#define MMA8451_I2C_ADDRESS (0x1d << 1)
#define BUFFER_SIZE 16
#define SLAVE_ADDR 0xA0

Serial pc(USBTX, USBRX);
I2C master(I2C_SDA, I2C_SCL);


int main(void)
{
    master.frequency (100000);
    pc.printf("\x1b[2J");      //CLEAR
    pc.printf("\r");           
    pc.printf("I'M MASTER\r\n");
   
    char buf[BUFFER_SIZE];
   
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    //            SDA    SCL         DIRECCIÓN
   
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
   
    if (master.read(SLAVE_ADDR, buf, BUFFER_SIZE) == 0)
        pc.printf("CONECTADO: %s\r\n", buf);

    float x, y, z; // Aceleracion en cada eje
   
    while (true) {
        x = abs(acc.getAccX()); // Obtener aceleracion en cada eje
        y = abs(acc.getAccY());
        z = abs(acc.getAccZ());
   
        rled = 1.0f - x; //Encender LED interno
        gled = 1.0f - y;
        bled = 1.0f - z;
       
        wait(0.5);
        
        sprintf(buf, "%1.1f, %1.1f, %1.1f", x, y, z);
        pc.printf("%s\r\n", buf);
       
       //Master escribe en slave
        if (master.write(SLAVE_ADDR, buf, BUFFER_SIZE) == 0)
            pc.printf("Escrito en slave: %s\r\n", buf);
       
        if (master.read(SLAVE_ADDR, buf, BUFFER_SIZE) == 0)
            pc.printf("Lee de slave: %s\r\n", buf);  
    }
} 