//CÓDIGO 2-B

#include <mbed.h>

Serial pc(USBTX, USBRX);
I2CSlave slave(I2C_SDA, I2C_SCL);

char addr = 0xA0;

int main()
{
    char buf[30];
    char msg[] = "Respuesta de Slave";
    pc.printf("\r");
    pc.printf("I'M SLAVE\r\n");
   
    slave.address(addr);
    slave.frequency (100000);
    pc.printf("SLAVE ID: %d\r\n",addr);
   
    while (1)
    {
        int i = slave.receive();
        switch (i) {
            case I2CSlave::ReadAddressed:
                slave.write(msg, strlen(msg) + 1);
                NVIC_SystemReset();
                break;
            case I2CSlave::WriteGeneral:
                slave.read(buf, 30);
                printf("Read General: %s\n", buf);
                break;
            case I2CSlave::WriteAddressed:
                slave.read(buf, 30);
                printf("Read Addressed: %s\n", buf);
                break;
        }
        for (int i = 0; i < 30; i++)
            buf[i] = 0;    // Clear buffer
    }
}