//CÓDIGO 2-A

#include "mbed.h"

#define BUFFER_SIZE 30
#define SLAVE_ADDR 0xA0

Serial pc(USBTX, USBRX); 
I2C master(I2C_SDA, I2C_SCL);

static const char* to_send[] = { "me gusta", " el pan ", "de dulce" };

int main() 
{
    pc.printf("\x1b[2J");       //CLEAR
    pc.printf("\033[1;1H");     //Mueve cursor al origen
            
    pc.printf("MASTER\r\n");
    
    master.frequency (100000);
    char buf[BUFFER_SIZE];
    int send_index = 0;
    while (1) 
    {
        wait(0.5);
        strcpy(buf, to_send[send_index]);
        
        //Master escrbe 
        if (master.write(SLAVE_ADDR, buf, BUFFER_SIZE) == 0)  {
            pc.printf("Escribe a slave: %s\r\n", buf);
        } 
        
        //Master lee
        if (master.read(SLAVE_ADDR, buf, BUFFER_SIZE) == 0) {
            pc.printf("Lee de slave: %s\r\n", buf);   
        }
        
        send_index++;
        if (send_index > 2) {
            send_index = 0;
        }
    }
}