//CÓDIGO 1-B

#include "mbed.h"
#include "stdlib.h"
#include <LiquidCrystal_I2C.h>
#include <iostream>
#include <string>

Serial pc(USBTX, USBRX); // tx, rx

//Los puertos SDA  y SD8 están referenciados en el archivo LiquidCrystal_I2C.cpp
// SDA -> PTC9
// SCL -> PTC8
//                     DIR   TIPO
LiquidCrystal_I2C lcd(0x4E, 16, 2);

int main()
{
    pc.printf("\x1b[2J");       //CLEAR
    pc.printf("\033[1;1H");     //Mueve cursor al origen
    
    int i, j;
    char datos[3][5]; // Matriz para almacenar datos
    
    // Inicia la LCD
    lcd.begin();
    
    lcd.print("Esperando ...");
    pc.printf("\nIngresa 3 numeros decimales de la forma <X.X> SIN PRESIONAR ENTER\r\n");
    
    for (i = 0; i < 3; i++) // Obtencion de datos desde terminal
    {
        pc.printf("\r\nDato %i: ", i + 1);
        for (j = 0; j < 3; j ++)
            datos[i][j] = pc.getc();
        datos[i][3] = ' ';
        datos[i][4] = 0;
        pc.printf("   %s", datos[i]);
    }
    
    lcd.clear();
    lcd.print("Datos obtenidos: ");
    lcd.setCursor(2, 1);
    lcd.print(datos[0]); //Imprime datos obtenidos de terminal
    lcd.print(datos[1]);
    lcd.print(datos[2]);
    
    pc.printf("\n\r\nDatos enviados a la LCD...");
}