//CÓDIGO 1-A

#include "mbed.h"
#include "MMA8451Q.h"
 
Serial pc(USBTX, USBRX);

#define MMA8451_I2C_ADDRESS (0x1d << 1)
 
int main(void)
{
    pc.printf("\x1b[2J");       //CLEAR
    pc.printf("\033[1;1H");     //Mueve cursor al origen
        
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    //            SDA    SCL         DIRECCIÓN
    
    PwmOut rled(LED1); // Declaracion de LED interno
    PwmOut gled(LED2);
    PwmOut bled(LED3);
 
    pc.printf("MMA8451 ID: %d\r\n", acc.getWhoAmI());
 
    while (true) {
        float x, y, z; // Aceleracion en cada eje
        
        x = abs(acc.getAccX());
        y = abs(acc.getAccY());
        z = abs(acc.getAccZ());
        
        rled = 1.0f - x; // Encender el LED interno
        gled = 1.0f - y;
        bled = 1.0f - z;
        wait(1);
        pc.printf("X: %1.1f, Y: %1.1f, Z: %1.1f\r\n", x, y, z);
    }
}