#include "mbed.h"
#include "nRF51822n.h"
#include "RCBController.h"

#define DBG 0

nRF51822n   nrf;
Serial  pc(USBTX, USBRX);
/* LEDs for indication: */
DigitalOut  ConnectStateLed(LED1);
PwmOut  ControllerStateLed(LED2);


/* RCBController Service */
static const uint16_t RCBController_service_uuid = 0xFFF0;
static const uint16_t RCBController_Characteristic_uuid = 0xFFF1;
GattService         RCBControllerService (RCBController_service_uuid);
GattCharacteristic  Controller (RCBController_Characteristic_uuid,10, 10,
								GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | 
								GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);

/* Advertising data and parameters */
GapAdvertisingData   advData;
GapAdvertisingData   scanResponse;
GapAdvertisingParams advParams ( GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED );

uint16_t	uuid16_list[] = { RCBController_service_uuid };

RCBController controller;

// GapEvent
class GapEventHandler : public GapEvents
{
     
    virtual void onConnected(void)
    {
        ConnectStateLed = 1;
#if DBG
		pc.printf("Connected\n\r");
#endif
    }

    virtual void onDisconnected(void)
    {
        nrf.getGap().startAdvertising(advParams);
		ConnectStateLed = 1;
#if DBG
		pc.printf("Disconnected\n\r");
#endif
    }
};

// GattEvent
class GattServerEventHandler : public GattServerEvents
{
	virtual void onDataWritten(uint16_t charHandle)
	{
   		if (charHandle == Controller.handle) {
	        nrf.getGattServer().readValue(Controller.handle, &controller.data[0], sizeof(controller));
#if DBG
			pc.printf("DATA:%d %d %d %d %d %d %d %d %d %d\n\r",controller.data[0],controller.data[1],controller.data[2],controller.data[3],controller.data[4],
															   controller.data[5],controller.data[6],controller.data[7],controller.data[8],controller.data[9]);
#endif
			//ControllerStateLed = (float)controller.status.LeftAnalogLR / 255.0;
			ControllerStateLed = (float)controller.status.LeftAnalogUD / 255.0;
			
		}
		 
	}
};

/**************************************************************************/
/*!
    @brief  Program entry point
*/
/**************************************************************************/
int main(void)
{
#if DBG
		pc.printf("Start\n\r");
#endif
    /* Setup an event handler for GAP events i.e. Client/Server connection events. */
    nrf.getGap().setEventHandler(new GapEventHandler());
    
    /* Initialise the nRF51822 */
    nrf.init();
    
    nrf.getGattServer().setEventHandler(new GattServerEventHandler());

    /* Make sure we get a clean start */
    nrf.reset();    

    /* Add BLE-Only flag and complete service list to the advertising data */
    advData.addFlags(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    advData.addData(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, 
                   (uint8_t*)uuid16_list, sizeof(uuid16_list));
    nrf.getGap().setAdvertisingData(advData, scanResponse);
	
	/* RCBController Service */
	RCBControllerService.addCharacteristic(Controller);
    nrf.getGattServer().addService(RCBControllerService);

    /* Start advertising (make sure you've added all your data first) */
    nrf.getGap().startAdvertising(advParams);
    ConnectStateLed = 0;
    ControllerStateLed = 1;

    for (;;)
    {
        wait(1);
    }
}

