#include "mbed.h"
#include "nRF51822n.h"

#define DBG 1

nRF51822n   nrf;
Serial  pc(USBTX, USBRX);
/* LEDs for indication: */
DigitalOut knsPio[]={P0_0,P0_1,P0_2,P0_3,P0_4,P0_5,P0_6,P0_7};
DigitalOut  ConnectStateLed(LED1);

static const uint16_t KONASHI_SERVICE_UUID = 0xFF00;
GattService         knsService (KONASHI_SERVICE_UUID);

/*
static const uint16_t KONASHI_PIO_SETTING_UUID = 0x3000;
GattCharacteristic  knsPioSetting (KONASHI_PIO_SETTING_UUID,1, 1,
	GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | 
	GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
*/
static const uint16_t KONASHI_PIO_OUTPUT_UUID = 0x3002;
GattCharacteristic  knsPioOut (KONASHI_PIO_OUTPUT_UUID,1, 1,
	GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | 
	GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);

/* Advertising data and parameters */
GapAdvertisingData   advData;
GapAdvertisingData   scanResponse;
GapAdvertisingParams advParams ( GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED );

uint16_t	uuid16_list[] = { KONASHI_SERVICE_UUID };

//==================================
uint8_t pioSetting=0xFF;
uint8_t pioOut=0;

void DoPio(void) {
	uint8_t b=1,vs,vo;
	for(int i=0;i<8;i++) {
		vs=(pioSetting & b);
		vo=(pioOut & b);
		knsPio[i]=(vs>0 && vo>0);
		b=(b<<1);
	}
}
//==================================

// GapEvent
class GapEventHandler : public GapEvents
{
     
    virtual void onConnected(void)
    {
        ConnectStateLed = 0;
        knsPio[0]=0;
		knsPio[1]=0;

#if DBG
		pc.printf("Connected\n\r");
#endif
    }

    virtual void onDisconnected(void)
    {
        nrf.getGap().startAdvertising(advParams);
		ConnectStateLed = 1;
		knsPio[0]=1;
		knsPio[1]=1;
#if DBG
		pc.printf("Disconnected\n\r");
#endif
    }
};

// GattEvent
class GattServerEventHandler : public GattServerEvents
{
	virtual void onDataWritten(uint16_t charHandle)
	{
   		/*if (charHandle == knsPioSetting.handle) {
   			uint8_t getPioSetting;
	        nrf.getGattServer().readValue(knsPioSetting.handle, &getPioSetting, 1);
	        if(getPioSetting!=pioSetting) {
	        	//DoPio();
	        	pioSetting=getPioSetting;
	        }
	        
		} else */
		if (charHandle == knsPioOut.handle) {
	        uint8_t getPioOut;
	        nrf.getGattServer().readValue(knsPioOut.handle, &getPioOut, 1);
	        #if DBG
	        	pc.printf("DATA: %d %d\n\r",getPioOut,pioOut);
	        #endif
	        if(getPioOut!=pioOut) {
	        	pioOut=getPioOut;
	        	DoPio();
	        }
		} 
	}
};

/**************************************************************************/
/*!
    @brief  Program entry point
*/
/**************************************************************************/
int main(void)
{
#if DBG
		pc.printf("Start\n\r");
#endif
    /* Setup an event handler for GAP events i.e. Client/Server connection events. */
    nrf.getGap().setEventHandler(new GapEventHandler());
    
    /* Initialise the nRF51822 */
    nrf.init();
    
    nrf.getGattServer().setEventHandler(new GattServerEventHandler());

    /* Make sure we get a clean start */
    nrf.reset();    

    /* Add BLE-Only flag and complete service list to the advertising data */
    advData.addFlags(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    advData.addData(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, 
                   (uint8_t*)uuid16_list, sizeof(uuid16_list));
    nrf.getGap().setAdvertisingData(advData, scanResponse);
	
	/* Service */
	//knsService.addCharacteristic(knsPioSetting);
	knsService.addCharacteristic(knsPioOut);
    nrf.getGattServer().addService(knsService);

    /* Start advertising (make sure you've added all your data first) */
    nrf.getGap().startAdvertising(advParams);
    ConnectStateLed = 1;

    for (;;)
    {
        wait(1);
    }
}

