#include "mbed.h"
#include "rtos.h"
#include "Keypad.h"
#include "TextLCD.h"
#include "buzzer.h"
 
Serial PC(USBTX, USBRX);
TextLCD * lcd;
Buzzer * buzzer;
RtosTimer *LedTimer;
DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
 
// Define your own keypad values
char Keytable[] = { '1', '2', '3',    // r0
                     '4', '5', '6',   // r1
                     '7', '8', '9',   // r2
                     '*', '0', '#',   // r3
                   };
 
int32_t       Index = -1;
int           State;
 
uint32_t cbAfterInput(uint32_t _index)
{
    Index = _index;
    return 0;
}
 
void Blink(void const *arg) {
    if (State == 1)  {
        Led1 = 1;
        Led2 = 0;
        State = 2;
    }
    else if (State == 2)  {
        LedTimer->stop();
        Led1 = 0;
        Led2 = 1;
        LedTimer->start(2000); // longer timer alarm
        State = 1;
    }
}
 
int main()
{
    lcd = new TextLCD( PTC5, PTC7, PTC0, PTC9, PTC8, PTC1, TextLCD::LCD20x4 );
    lcd->printf("I am Demo Keypad\r\n");
    State = 1;
    LedTimer = new RtosTimer(&Blink, osTimerPeriodic, NULL);
    LedTimer->start(500); // short timer alarm    
    
    buzzer = new Buzzer(PTA2);
    buzzer->startupBeep();
    
    //             r0   r1   r2   r3   c0   c1   c2   c3
    //Keypad keypad(p21, p22, p23, p24, p25, p28, p27, NC);
    Keypad keypad(PTC4, PTB23, PTC2, PTE26, PTB20, PTB2, PTC3, NC);
    
    keypad.attach(&cbAfterInput);
    keypad.start();  // energize the columns c0-c3 of the keypad
 
    while (1) {
        __wfi();
        if (Index > -1) {
            lcd->cls();
            lcd->locate(0, 0);
            lcd->printf("Interrupted");
            lcd->locate(0, 1);
            lcd->printf("Index:%d => Key:%c\r\n", Index, Keytable[Index]);
            Index = -1;
        }
    }
}