#include "mbed.h"
#include "HIDScope.h"

//Define objects
AnalogIn    emg0( A0 );         //emg sensor A0
AnalogIn    emg1( A1 );         //emg sensor A1
AnalogIn    emg2( A2 );         //emg sensor A3
DigitalIn button_emg(D4);       //button for emg calibration (pin must be ckecked if empty

Ticker      sample_timer;
HIDScope    scope( 6 );         //6 channels in hidscope
DigitalOut  led(LED1);

/** Sample function
 * this function_Samples the emg_and_Sends it to HIDScope_
 **/
void sample()
{
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    scope.set(0, emg0.read() );
    scope.set(1, emg1.read() );
    scope.set(2, emg2.read() );

    scope.send();
    /* To indicate that the function is working, the LED is toggled */
    led = !led;
}

int main()
{   
    /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz
    */
//______emg calibration______// 
    while (button_emg == false) {
        if (&sample >= 0,05) { 
            &sample = &sample*2; 
        }
        else if (&sample >= 0,2) {
            &sample = &sample;
        }
        else ($sample >= 0,5) {
            &sample = &sample/2; 
        }
    }
    while (button_emg == true) {
    sample_timer.attach(&sample, 0.002);
    }
    /*empty loop, sample() is executed periodically*/
    while(1) {}
}