//______Libaries Included______//
#include "mbed.h"
#include "MODSERIAL.h"  //show stuf on screen
#include "HIDScope.h"   //visualise the analog potmeter signal

//______In/out puts____________//
PwmOut pwmpin(D6);              //motor_1 pwn control = (motor speed)
//PwmOut pwmpin2(D5);              //motor_2 pwn control = (motor speed)
DigitalOut directionpin(D7);    //motor_1 (direction control)
//DigitalOut directionpin2(D4);    //motor_2 (direction control)  

AnalogIn    emg0( A0 );         //emg sensor A0
AnalogIn    emg1( A1 );         //emg sensor A1
AnalogIn    emg2( A2 );         //emg sensor A3
        
AnalogIn potmeter(A5);          //potmeter pin (A5) (Control speed and direction)
//AnalogIn potmeter2(A4);         //potmeter pin (A4) (Control speed and direction)

PwmOut led(D10);                //led pot1
//PwnOut led2(D9);                 //led pot2
MODSERIAL pc(USBTX, USBRX);     //show stuf on screen
//DigitalIn button(D2);           //not yet used 


//______Global stuf____________//
//HIDScope scope(2);                      //use 2 channels
Ticker ticker;                          //moter ticker
enum states{forward, stop, backwards};  //motor_1 states
states CurrentState;

//______For EMG________________//
Ticker      sample_timer;       //emg ticker
HIDScope    scope( 6 );         //6 channels in hidscope
DigitalOut  led_emg(LED1);

//______Global variables_______//
volatile float x;
volatile float y;
volatile float scaled_potmeter;
volatile float c;

//______Function: Hidscope_emg__//
void sample()
{
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    scope.set(0, emg0.read() );
    scope.set(1, emg1.read() );
    scope.set(2, emg2.read() );

    scope.send();
    /* To indicate that the function is working, the LED is toggled */
    led_emg = !led_emg;
}

void sendData() {
    scope.set(3,potmeter);  //set the potmeter data to the 3th scope
    scope.set(4,x);
    scope.send();           //send the datapoints of the potmeter
}

//______Funcion: Motor state + Makes moter do stuf___//
void Proces_states(){
    switch (CurrentState){       
        case forward:                   //Funcion: Forward
//            directionpin = 1;
//            pwmpin.write(scaled_potmeter);  //pwm of motor is potmeter value
            led.write(scaled_potmeter);     //led is potmeter value  
            break;
        case stop:                      //Funcion: Stop
                                        // do nothing
            break;
        case backwards:                 //Function: Backwards
//            directionpin = 0;
            c = scaled_potmeter*-1;
//            pwmpin.write(c);            //pwm of motor is potmeter value
            led.write(c);               //led is potmeter value 
            break; 
    }            
}

//______Funcion: Main____________//
int main() {
    x = 1;                              //placeholder value for potmeter of second motor
    
    pwmpin.period_us(60);               //60 microseconds PWM period, 16.7 kHz
    led.period_us(60);                  //60 microseconds
    ticker.attach(&sendData, 0.005f);   //send data to hidscope 1/0.005 = 200Hz
    sample_timer.attach(&sample, 0.002);    //for the emg

//______Scale potmeter___________//
    while (true) {  
        scaled_potmeter = (potmeter*2)-1; //scale potmeter from 0-1 to (-1 to 1)

//______Readout potmeter + giva and call to Proces_state______//
        if (scaled_potmeter > 0) {
            CurrentState = forward;
            pc.printf("state = forward\r\n");
            Proces_states();
        }
        if (scaled_potmeter == 0) {
            CurrentState = stop;
            pc.printf("state = stop\r\n");
            Proces_states(); 
        }
        if (scaled_potmeter < 0) {
            CurrentState = backwards;
            pc.printf("state = backwards\r\n");
            Proces_states(); 
        }   

        wait(0.2f);
        
        /**Attach the 'sample' function to the timer 'sample_timer'.
        * this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz
        */


        /*empty loop, sample() is executed periodically*/
        //while(1) {}
    }

}


