#ifndef MAX2769TW_H
#define MAX2769TW_H

#include "mbed.h"

/** An MAX2769TW class
 * It uses the Three Wire peripheral of the LPC1768
 * @author mbavaro
 * More details about the function goes here
 * 
 * An example:
 * @code
 * #include "MAX2769TW.h"
 * #include "mbed.h"
 * 
 * MAX2769TW gpsSpi(p24, p25, p26);
 * const uint32_t confArray[10] = {...};
 * 
 * void main()
 * {
 *      int k;
 *
 *      for (k=0; k<10; k++) {
 *          gpsSpi.SendReg(confArray[k]);
 *      }
 *     
 * }
 * @endcode
 */
class MAX2769TW
{
    private:
        DigitalOut sData;
        DigitalOut sClk;
        DigitalOut sCs;
        
    public:
        /** Creates an MAX2769TW object to program the chip
         *
         * @param _sData    Data Digital Input of 3-Wire Serial Interface
         * @param _sClk     Clock Digital Input of 3-Wire Serial Interface. 
         *                  Active when CS is low. Data is clocked in on the rising
         *                  edge of the SCLK.
         * @param _sCs      Chip-Select Logic Input of 3-Wire Serial Interface. 
         *                  Set CS low to allow serial data to shift in. Set CS high
         *                  when the loading action is completed.
         */
        MAX2769TW(PinName _sData, PinName _sClk, PinName _sCs);
        
        /** Destructs the MAX2769TW object */
        ~MAX2769TW();

        /** Streams the register content compliant with the 3-Wire protocol
         *
         * @param uiReg   The 32-bit configuration register 
         */
        void SendReg(uint32_t _uiReg);
};
#endif /* MAX2769TW_H */