#include "mbed.h"
#include "max2769tw.h"

MAX2769TW::MAX2769TW(PinName _sData, PinName _sClk, PinName _sCs) :
    sData(_sData), sClk(_sClk), sCs(_sCs)
{
    sData = 0;
    sClk  = 0;
    sCs   = 1;
}

MAX2769TW::~MAX2769TW() {
    // do nothing
}

void MAX2769TW::SendReg(uint32_t _uiReg) {
    int k;
    
    wait_us(3); sClk = 1;
    wait_us(3); sClk = 0;
    wait_us(3); sCs  = 0;
    for (k=31; k>=0; k--) {
        if ((_uiReg >> k) & 0x1) {
            sData = 1;
        } else {
            sData = 0;        
        }
        wait_us(3); sClk = 1;
        wait_us(3); sClk = 0;
    }
    wait_us(3); sCs  = 1;    
    wait_us(3); sClk = 1;
    wait_us(3); sClk = 0;
    sData = 0;
}