#ifndef MAX2769SSP0_H
#define MAX2769SSP0_H

#include "mbed.h"

extern Serial pc;
extern DigitalOut myled1;
extern DigitalOut myled2;

/** An MAX2769SSP0 class
 * It configures a SSP0 slave with TI protocol 
 * @author Michele Bavaro
 * More details about the function goes here
 * 
 * An example:
 * @code
 * #include "max2769ssp0.h"
 * #include "mbed.h"
 * 
 * MAX2769SSP0 adcSSP0(p11, p12, p13, p14);
 * const uint16_t *puiMem;
 * 
 * void main()
 * {
 *     
 * }
 * @endcode
 */
class MAX2769SSP0
{
    private:
       int sppx;
       
    public:
        /** Creates an MAX2769SSP0 object to program the chip
         *
         * @param _mosi     Data Digital Input of 3-Wire Serial Interface.
         * @param _sck      Clock Digital Input of 3-Wire Serial Interface.
         *                  Active when CS is low. Data is clocked in on the rising
         *                  edge of the SCLK.
         * @param _ssel     Chip-Select Logic Input of 3-Wire Serial Interface
         *                  Set CS low to allow serial data to shift in. Set CS high
         *                  when the loading action is completed.
         */
        MAX2769SSP0(PinName _mosi, PinName _sck, PinName _ssel);
        
        /** Destructs the MAX2769SSP0 object */
        ~MAX2769SSP0();

        /** Reads from SSP0 into memory 
         *
         * @param _puiMem   Pointer to a 16-bits aligned memory space where data will be written
         * @param _iSize    Number of locations of the memory to be written
         */
        void Read(uint16_t *_puiMem, uint32_t _iLocations);
        
};
#endif /* MAX2769SSP0_H */