#include "mbed.h"
#include "max2769tw.h"
#include "max2769ssp0.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

#define N_BYTES (16*1024)
#define N_XFER  (N_BYTES / sizeof(uint16_t))

Serial pc(USBTX, USBRX);

MAX2769TW   spiGpsCtl(p24, p25, p26);   // data, clock, chip select

MAX2769SSP0 spiGpsAdc(p11, p13, p14);   // data, clock, frame

const unsigned int gpsConfRegArray[10] = 
    {0x82938E30, 
     0x85500081, 
     0xEAFE8062, 
     0x9AC00003,
     0x00780084, 
     0x87D3E705, 
     0x00010006, 
     0x10061B17, 
     0x1E0F4018, 
     0x14C04029};

     
int main() {
    int k;
    uint16_t *ptMem16;
    
    pc.baud(115200);
    
    myled1 = myled2 = myled3 = myled4 = 1;
    wait(1);
    myled1 = myled2 = myled3 = myled4 = 1;
    
    // 
    // PROGRAM THE MAX2769
    //
    myled2 = 1;
    for (k=0; k<10; k++) {
        myled1 = 1;
        spiGpsCtl.SendReg(gpsConfRegArray[k]);
        myled1 = 0;
    }
    myled2 = 0;
    
    // 
    // GET THE DATA SNAPSHOT FROM THE GPS FRONT-END
    //
    ptMem16 = (uint16_t*) malloc(N_BYTES);
    if (NULL != ptMem16) {
        // Write in memory, probably need DMA later
        myled3 = 1;
        memset(ptMem16, 0, N_BYTES);
        spiGpsAdc.Read(ptMem16, N_XFER);
        myled3 = 0;       
    }

    //
    // SEND SOME DEBUG DATA TO THE SERIAL PORT
    //
    if (NULL != ptMem16) {
        k = 0;     
        while (k < N_XFER) {
            myled2 = 1;
            pc.printf("%04x:%04x%04x%04x%04x%04x%04x%04x%04x\n", 
                k*sizeof(uint16_t), 
                ptMem16[k+ 0], ptMem16[k+ 1], ptMem16[k+ 2], ptMem16[k+ 3],
                ptMem16[k+ 4], ptMem16[k+ 5], ptMem16[k+ 6], ptMem16[k+ 7] );
            k += 8;
            myled2 = 0;
        }
    }

    // Free the allocated memory
    if (NULL != ptMem16) {
        free(ptMem16);
        ptMem16 = NULL;
    }    
    
    // Go idle
    while (1) {
        myled4 = 1;
        wait(1);
        myled4 = 0;
        wait(1);
    }
}

