/*******************************************************************************

t5bootloaders.h - definitions for the MyBooty bootloader for T5 ECU's
(c) 2010,2011,2012,2013,2014,2015 by Sophie Dexter

********************************************************************************

WARNING: Use at your own risk, sadly this software comes with no guarantees.
This software is provided 'free' and in good faith, but the author does not
accept liability for any damage arising from its use.

*******************************************************************************/
#ifndef __T5BOOTLOADERS_H__
#define __T5BOOTLOADERS_H__

// MyBooty bootloader
//
// This is version 2.1
//
// Start address is 0x5000
#define MYBOOTY_START 0x5000
// Send MyBooty in chunks of 0x20 bytes
#define MYBOOTY_CHUNK 0x20
// The size of the array must be 'padded' out with 0x00's to be a multiple of 0x20 bytes because 't5_can_send_boot_loader' is coded with magic numbers!
#define MYBOOTY {\
0x4E,0xB8,0x50,0x0C,0x4E,0xB8,0x50,0xAC,0x4E,0xED,0x00,0x04,0x20,0x7C,0x00,0xFF,0xFA,0x04,0x10,0xFC,0x00,0x7F,0x08,0x10,0x00,0x03,0x67,0xFA,0x33,0xFC,0x04,0x05,\
0x00,0xFF,0xFA,0x48,0x33,0xFC,0x04,0x05,0x00,0xFF,0xFA,0x50,0x33,0xFC,0x04,0x05,0x00,0xFF,0xFA,0x54,0x33,0xFC,0x30,0x30,0x00,0xFF,0xFA,0x52,0x33,0xFC,0x50,0x30,\
0x00,0xFF,0xFA,0x56,0x02,0x79,0xFF,0xBF,0x00,0xFF,0xFC,0x14,0x00,0x79,0x00,0x10,0x00,0xFF,0xFC,0x14,0x02,0x79,0x8F,0xDF,0x00,0xFF,0xFC,0x16,0x00,0x79,0x00,0x50,\
0x00,0xFF,0xFC,0x16,0x2A,0x7C,0x00,0x04,0x00,0x00,0x2C,0x7C,0x00,0xFF,0xFA,0x26,0x3C,0x3C,0x55,0x55,0x3E,0x3C,0xAA,0xAA,0x24,0x7C,0x00,0xF0,0x07,0xFF,0x26,0x7C,\
0x00,0xF0,0x08,0x00,0x40,0xC1,0x00,0x7C,0x07,0x00,0x42,0x12,0x00,0x13,0x00,0x01,0x14,0xBC,0x00,0x01,0x08,0x13,0x00,0x00,0x67,0xFA,0x14,0xBC,0x00,0x04,0x16,0xBC,\
0x00,0x01,0x42,0x12,0x02,0x13,0x00,0xFE,0x46,0xC1,0x4E,0x75,0x4E,0xB8,0x51,0xE4,0x20,0x7C,0x00,0x00,0x57,0x90,0x22,0x7C,0x00,0x00,0x57,0x98,0x10,0x10,0x12,0xC0,\
0x12,0xFC,0x00,0x09,0x22,0xFC,0x08,0x08,0x08,0x08,0x32,0xBC,0x08,0x08,0x5B,0x89,0x0C,0x00,0x00,0xC7,0x67,0x00,0x00,0xD8,0x0C,0x00,0x00,0x7F,0x63,0x00,0x00,0x5E,\
0x0C,0x00,0x00,0xA5,0x67,0x00,0x00,0x42,0x0C,0x00,0x00,0xC0,0x67,0x00,0x00,0x8A,0x0C,0x00,0x00,0xC2,0x67,0x00,0x00,0x9E,0x0C,0x00,0x00,0xC3,0x67,0x00,0x00,0xA4,\
0x0C,0x00,0x00,0xC8,0x67,0x00,0x00,0xC2,0x0C,0x00,0x00,0xC9,0x67,0x00,0x00,0xC2,0x4E,0xB8,0x52,0x4C,0x0C,0x38,0x00,0xC2,0x57,0x98,0x66,0x90,0x14,0xBC,0x00,0x08,\
0x08,0x13,0x00,0x06,0x67,0xFA,0x4E,0x75,0x20,0x18,0xE1,0x88,0x80,0x18,0x21,0xC0,0x57,0xA2,0x11,0xD0,0x57,0xA6,0x42,0x11,0x60,0x00,0xFF,0xD6,0x24,0x7C,0x00,0x00,\
0x57,0xA7,0x70,0x06,0x42,0x81,0x12,0x18,0xD5,0xC1,0x14,0x38,0x57,0xA6,0x14,0xD8,0x52,0x01,0xB2,0x02,0x67,0x0A,0x51,0xC8,0xFF,0xF6,0x42,0x11,0x60,0x00,0xFF,0xB2,\
0x4E,0xB8,0x54,0xE4,0x12,0xC0,0x67,0x00,0xFF,0xA8,0x22,0x84,0x02,0x79,0xFF,0xBF,0x00,0xFF,0xFC,0x14,0x60,0x00,0xFF,0x9A,0x4E,0xB8,0x56,0xFA,0x4E,0xB8,0x52,0x9C,\
0x12,0xC0,0x67,0x00,0xFF,0x8C,0x22,0x82,0x02,0x79,0xFF,0xBF,0x00,0xFF,0xFC,0x14,0x60,0x00,0xFF,0x7E,0x02,0x79,0xFF,0xBF,0x00,0xFF,0xFC,0x14,0x42,0x11,0x60,0x00,\
0xFF,0x70,0x42,0x19,0x22,0xBC,0x00,0x07,0xFF,0xFF,0x60,0x00,0xFF,0x64,0x20,0x18,0xE1,0x88,0x80,0x10,0x24,0x40,0x42,0x19,0x12,0xD2,0x12,0xE2,0x12,0xE2,0x12,0xE2,\
0x12,0xE2,0x12,0xA2,0x60,0x00,0xFF,0x4A,0x4E,0xB8,0x56,0x70,0x60,0x00,0xFF,0x42,0x4E,0xB8,0x56,0xFA,0x42,0x19,0x22,0xCD,0x12,0xF8,0x57,0xA0,0x12,0xB8,0x57,0xA1,\
0x60,0x00,0xFF,0x2E,0x20,0x7C,0x00,0x00,0x57,0x90,0x24,0x7C,0x00,0xF0,0x07,0xFF,0x26,0x7C,0x00,0xF0,0x08,0x00,0x40,0xC1,0x00,0x7C,0x07,0x00,0x14,0xBC,0x00,0x02,\
0x4A,0x13,0x14,0xBC,0x00,0x12,0x08,0x13,0x00,0x00,0x67,0xFA,0x14,0xBC,0x00,0x13,0x08,0x13,0x00,0x06,0x66,0x08,0x46,0xC1,0x3C,0x86,0x3C,0x87,0x60,0xD8,0x14,0xBC,\
0x00,0x13,0x16,0xBC,0x00,0x08,0x70,0x14,0x74,0x1B,0x14,0x80,0x52,0x00,0x10,0xD3,0xB0,0x02,0x63,0xF6,0x14,0xBC,0x00,0x12,0x08,0x13,0x00,0x00,0x67,0xFA,0x14,0xBC,\
0x00,0x13,0x08,0x13,0x00,0x06,0x66,0xD6,0x46,0xC1,0x4E,0x75,0x22,0x7C,0x00,0x00,0x57,0x98,0x24,0x7C,0x00,0xF0,0x07,0xFF,0x26,0x7C,0x00,0xF0,0x08,0x00,0x40,0xC1,\
0x00,0x7C,0x07,0x00,0x14,0xBC,0x00,0x02,0x4A,0x13,0x14,0xBC,0x00,0x06,0x42,0x13,0x14,0xBC,0x00,0x07,0x08,0x13,0x00,0x00,0x67,0xFA,0x70,0x09,0x74,0x10,0x14,0x80,\
0x52,0x00,0x16,0x99,0xB0,0x02,0x63,0xF6,0x14,0xBC,0x00,0x08,0x16,0xBC,0x00,0x88,0x14,0xBC,0x00,0x06,0x16,0xBC,0x00,0x80,0x46,0xC1,0x4E,0x75,0x10,0x38,0x57,0xA0,\
0x12,0x38,0x57,0xA1,0x0C,0x00,0x00,0x89,0x66,0x16,0x0C,0x01,0x00,0xB8,0x67,0x00,0x01,0x04,0x0C,0x01,0x00,0xB4,0x67,0x00,0x00,0xF4,0x70,0x04,0x60,0x00,0x02,0x24,\
0x0C,0x00,0x00,0x01,0x66,0x1E,0x0C,0x01,0x00,0x25,0x67,0x00,0x00,0xE8,0x0C,0x01,0x00,0xA7,0x67,0x00,0x00,0xD8,0x0C,0x01,0x00,0x20,0x67,0x00,0x01,0x8C,0x70,0x05,\
0x60,0x00,0x02,0x00,0x0C,0x00,0x00,0x31,0x66,0x0E,0x0C,0x01,0x00,0xB4,0x67,0x00,0x00,0xBC,0x70,0x06,0x60,0x00,0x01,0xEC,0x0C,0x00,0x00,0x1F,0x66,0x12,0x0C,0x01,\
0x00,0xD5,0x67,0x4E,0x0C,0x01,0x00,0x5D,0x67,0x50,0x70,0x07,0x60,0x00,0x01,0xD4,0x0C,0x00,0x00,0xBF,0x66,0x0E,0x0C,0x01,0x00,0xB5,0x67,0x00,0x01,0x4C,0x70,0x08,\
0x60,0x00,0x01,0xC0,0x0C,0x00,0x00,0x20,0x66,0x0E,0x0C,0x01,0x00,0x20,0x67,0x00,0x01,0x38,0x70,0x09,0x60,0x00,0x01,0xAC,0x0C,0x00,0x00,0x37,0x66,0x0E,0x0C,0x01,\
0x00,0xA4,0x67,0x00,0x01,0x24,0x70,0x0A,0x60,0x00,0x01,0x98,0x70,0x03,0x60,0x00,0x01,0x92,0x24,0x3C,0x00,0x04,0x00,0x00,0x60,0x06,0x24,0x3C,0x00,0x02,0x00,0x00,\
0x3B,0x87,0x01,0x70,0x00,0x00,0xAA,0xAA,0x3B,0x46,0x55,0x54,0x3B,0xBC,0x80,0x80,0x01,0x70,0x00,0x00,0xAA,0xAA,0x3B,0x87,0x01,0x70,0x00,0x00,0xAA,0xAA,0x3B,0x46,\
0x55,0x54,0x3B,0xBC,0x10,0x10,0x01,0x70,0x00,0x00,0xAA,0xAA,0x32,0x3C,0xAB,0xE0,0x4E,0x71,0x51,0xC9,0xFF,0xFC,0x50,0xC0,0x3C,0x86,0x3C,0x87,0xB0,0x35,0x28,0xFF,\
0x66,0x00,0x01,0x3E,0x53,0x82,0x66,0xF0,0x60,0x00,0x01,0x32,0x24,0x3C,0x00,0x04,0x00,0x00,0x60,0x06,0x24,0x3C,0x00,0x02,0x00,0x00,0x20,0x02,0x16,0x3C,0x00,0x40,\
0x18,0x3C,0x00,0xC0,0x3A,0xBC,0xFF,0xFF,0x3A,0xBC,0xFF,0xFF,0x42,0x55,0x4A,0x35,0x28,0xFF,0x67,0x24,0x7A,0x19,0x1B,0x83,0x28,0xFF,0x42,0x35,0x28,0xFF,0x72,0x15,\
0x4E,0x71,0x51,0xC9,0xFF,0xFC,0x1B,0x84,0x28,0xFF,0x72,0x0C,0x4E,0x71,0x51,0xC9,0xFF,0xFC,0x4A,0x35,0x28,0xFF,0x66,0x0A,0x3C,0x86,0x3C,0x87,0x53,0x82,0x66,0xCC,\
0x60,0x04,0x53,0x45,0x66,0xD0,0x42,0x55,0x4A,0x55,0x4A,0x05,0x66,0x06,0x70,0x02,0x60,0x00,0x00,0xD0,0x24,0x00,0x50,0xC0,0x16,0x3C,0x00,0x20,0x18,0x3C,0x00,0xA0,\
0x2A,0x3C,0x03,0xE8,0x03,0xE8,0x1B,0x83,0x28,0xFF,0x1B,0x83,0x28,0xFF,0x32,0x3C,0x55,0xF0,0x4E,0x71,0x51,0xC9,0xFF,0xFC,0x1B,0x84,0x28,0xFF,0x72,0x0C,0x4E,0x71,\
0x51,0xC9,0xFF,0xFC,0x3C,0x86,0x3C,0x87,0xB0,0x35,0x28,0xFF,0x66,0x08,0x48,0x45,0x53,0x82,0x66,0xE4,0x60,0x04,0x53,0x45,0x66,0xCC,0x42,0x55,0x4A,0x55,0x4A,0x45,\
0x67,0x00,0x00,0x7E,0x60,0x00,0x00,0x76,0x70,0x01,0x1B,0x87,0x09,0x30,0x00,0x00,0xAA,0xAA,0x1B,0x86,0x09,0x20,0x55,0x54,0x1B,0xBC,0x00,0x80,0x09,0x30,0x00,0x00,\
0xAA,0xAA,0x1B,0x87,0x09,0x30,0x00,0x00,0xAA,0xAA,0x1B,0x86,0x09,0x20,0x55,0x54,0x1B,0xBC,0x00,0x10,0x09,0x30,0x00,0x00,0xAA,0xAA,0x3C,0x86,0x3C,0x87,0x1A,0x35,\
0x08,0x00,0x08,0x05,0x00,0x07,0x66,0x2A,0x08,0x05,0x00,0x05,0x67,0xEC,0x1A,0x35,0x08,0x00,0x08,0x05,0x00,0x07,0x66,0x1A,0x1B,0x87,0x09,0x30,0x00,0x00,0xAA,0xAA,\
0x1B,0x86,0x09,0x20,0x55,0x54,0x1B,0xBC,0x00,0xF0,0x09,0x30,0x00,0x00,0xAA,0xAA,0x60,0x0E,0x53,0x80,0x67,0x00,0xFF,0x94,0x60,0x00,0x00,0x02,0x42,0x80,0x60,0x02,\
0x70,0x01,0x4E,0x75,0x26,0x7C,0x00,0x00,0x57,0xA2,0x28,0x53,0xBB,0xCC,0x62,0x00,0x01,0x7C,0x42,0x82,0x14,0x2B,0x00,0x04,0x12,0x38,0x57,0xA1,0x0C,0x01,0x00,0x20,\
0x67,0x00,0x00,0xEE,0x0C,0x01,0x00,0xD5,0x67,0x22,0x0C,0x01,0x00,0x5D,0x67,0x1C,0x0C,0x01,0x00,0xB5,0x67,0x00,0x00,0xDA,0x0C,0x01,0x00,0x20,0x67,0x00,0x00,0xD2,\
0x0C,0x01,0x00,0xA4,0x67,0x00,0x00,0xCA,0x60,0x00,0x00,0x78,0x20,0x0C,0x02,0x80,0x00,0x00,0x00,0xFF,0x99,0xC0,0x24,0x7C,0x00,0x00,0x58,0x28,0x22,0x3C,0x00,0x00,\
0x01,0x00,0x35,0xB4,0x18,0xFE,0x18,0xFE,0x55,0x81,0x66,0xF6,0xD5,0xC0,0x22,0x02,0x15,0xB3,0x18,0x04,0x18,0xFF,0x53,0x81,0x66,0xF6,0x95,0xC0,0x3B,0x87,0x01,0x70,\
0x00,0x00,0xAA,0xAA,0x3B,0x46,0x55,0x54,0x3B,0xBC,0xA0,0xA0,0x01,0x70,0x00,0x00,0xAA,0xAA,0x32,0x3C,0x01,0x00,0x39,0xB2,0x18,0xFE,0x18,0xFE,0x55,0x81,0x66,0xF6,\
0x32,0x3C,0x55,0xF0,0x4E,0x71,0x51,0xC9,0xFF,0xFC,0x32,0x3C,0x01,0x00,0x36,0x32,0x18,0xFE,0xB6,0x74,0x18,0xFE,0x66,0x00,0x00,0xD4,0x55,0x81,0x66,0xF0,0x60,0x00,\
0x00,0xC8,0x16,0x3C,0x00,0x40,0x18,0x3C,0x00,0xC0,0x10,0x33,0x28,0x04,0x0C,0x00,0x00,0xFF,0x67,0x24,0x7A,0x19,0x19,0x83,0x28,0xFF,0x19,0x80,0x28,0xFF,0x72,0x15,\
0x4E,0x71,0x51,0xC9,0xFF,0xFC,0x19,0x84,0x28,0xFF,0x72,0x0C,0x4E,0x71,0x51,0xC9,0xFF,0xFC,0xB0,0x34,0x28,0xFF,0x66,0x06,0x53,0x82,0x66,0xCE,0x60,0x04,0x53,0x05,\
0x66,0xD4,0x42,0x55,0x4A,0x55,0x4A,0x05,0x67,0x00,0x00,0x82,0x60,0x00,0x00,0x7A,0x12,0x3C,0x00,0xA0,0x20,0x0C,0xD0,0x82,0xC0,0xBC,0x00,0x00,0x00,0x01,0x08,0x40,\
0x00,0x00,0x16,0x33,0x28,0x04,0x0C,0x03,0x00,0xFF,0x67,0x58,0x1B,0x87,0x09,0x30,0x00,0x00,0xAA,0xAA,0x1B,0x86,0x09,0x20,0x55,0x54,0x1B,0x81,0x09,0x30,0x00,0x00,\
0xAA,0xAA,0x19,0x83,0x28,0xFF,0xC6,0x3C,0x00,0x80,0x18,0x34,0x28,0xFF,0x1A,0x04,0xC8,0x3C,0x00,0x80,0xB8,0x03,0x67,0x2C,0x08,0x05,0x00,0x05,0x67,0xEC,0x18,0x34,\
0x28,0xFF,0xC8,0x3C,0x00,0x80,0xB8,0x03,0x67,0x1A,0x1B,0x87,0x09,0x30,0x00,0x00,0xAA,0xAA,0x1B,0x86,0x09,0x20,0x55,0x54,0x1B,0xBC,0x00,0xF0,0x09,0x30,0x00,0x00,\
0xAA,0xAA,0x60,0x08,0x53,0x82,0x66,0x96,0x42,0x40,0x60,0x02,0x70,0x01,0x4E,0x75,0x24,0x7C,0x00,0x07,0xFF,0xFB,0x42,0x80,0x42,0x81,0x42,0x82,0x42,0x83,0x42,0x84,\
0x18,0x3C,0x00,0xFD,0x12,0x12,0x67,0x00,0x00,0x6C,0x0C,0x01,0x00,0xFF,0x67,0x00,0x00,0x64,0x10,0x2A,0xFF,0xFF,0x95,0xC1,0x55,0x8A,0xB0,0x04,0x66,0xE6,0x10,0x32,\
0x18,0x00,0x04,0x00,0x00,0x30,0x0C,0x40,0x00,0x0A,0x65,0x02,0x5F,0x00,0xE9,0x8A,0x84,0x00,0x53,0x01,0x66,0xE8,0xC5,0x43,0x0C,0x04,0x00,0xFE,0x67,0x04,0x52,0x04,\
0x60,0xC2,0xB6,0x82,0x63,0x2E,0x0C,0x83,0x00,0x07,0xFF,0xFF,0x64,0x26,0x52,0x83,0x24,0x42,0x42,0x80,0x42,0x81,0x3C,0x86,0x3C,0x87,0x12,0x1A,0xD0,0x81,0x12,0x1A,\
0xD0,0x81,0xB5,0xC3,0x66,0xF0,0xB0,0xB9,0x00,0x07,0xFF,0xFC,0x66,0x06,0x42,0x19,0x22,0x80,0x60,0x04,0x12,0xBC,0x00,0x01,0x4E,0x75,0x24,0x7C,0x00,0x00,0x57,0xA0,\
0x00,0x79,0x00,0x40,0x00,0xFF,0xFC,0x14,0x32,0x3C,0x55,0xF0,0x4E,0x71,0x51,0xC9,0xFF,0xFC,0x50,0xD5,0x50,0xD5,0x1A,0xBC,0x00,0x90,0x14,0xD5,0x14,0xAD,0x00,0x02,\
0x50,0xD5,0x50,0xD5,0x0C,0x22,0x00,0x89,0x67,0x64,0x0C,0x12,0x00,0x01,0x67,0x5E,0x0C,0x12,0x00,0x31,0x67,0x58,0x02,0x79,0xFF,0xBF,0x00,0xFF,0xFC,0x14,0x32,0x3C,\
0xAB,0xE0,0x4E,0x71,0x51,0xC9,0xFF,0xFC,0x1B,0x87,0x01,0x70,0x00,0x00,0xAA,0xAA,0x1B,0x46,0x55,0x54,0x1B,0xBC,0x00,0x90,0x01,0x70,0x00,0x00,0xAA,0xAA,0x32,0x3C,\
0x55,0xF0,0x4E,0x71,0x51,0xC9,0xFF,0xFC,0x14,0xD5,0x14,0xAD,0x00,0x02,0x1B,0x87,0x01,0x70,0x00,0x00,0xAA,0xAA,0x1B,0x46,0x55,0x54,0x1B,0xBC,0x00,0xF0,0x01,0x70,\
0x00,0x00,0xAA,0xAA,0x32,0x3C,0x55,0xF0,0x4E,0x71,0x51,0xC9,0xFF,0xFC,0x4E,0x75,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}


#endif