/* ============================================
Modified Code from Crius
The CriusOLED Hardware MUST be modified for correct function of ACK
Copyright (c) 2014 Michael Ruck michael@ruck.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
===============================================
*/

#include "mbed.h"
#include <time.h>
#include "CriusOLED.h"


//DigitalOut myled(D2);

Serial pc(SERIAL_TX, SERIAL_RX);

int main()
{
    time_t rawtime;
    struct tm timeinfo;
    struct tm * timeinfo2;
    char buffer [6];
    char buffer2[60];
    

    // Initialize I2C and OLED Display
    i2c.frequency(400000);
    init_OLED();
    displayOn();
    reset_display();


    timeinfo.tm_year = 2014-1900;
    timeinfo.tm_mon = 3-1;
    timeinfo.tm_mday = 13;

    timeinfo.tm_hour=0;
    timeinfo.tm_min=0;
    timeinfo.tm_sec=0;
    //timeinfo->tm_isds=0; // not implemented in mbed

    set_time(mktime(&timeinfo));
    pc.printf("%d\n\n", mktime(&timeinfo));
    
    while(1) {
        //myled != myled;
        clear_display();
        sendImage();
        wait(1.0);
        clear_display();
        sendStrXY("Code by M. Ruck",4,0);
        wait(1.0);
        //reset_display();
        clear_display();

        rawtime = time(NULL);
        timeinfo2 = localtime (&rawtime);
        strftime (buffer2, 60, "%d.%m.%Y %H:%M:%S", timeinfo2);
        pc.printf("%s\n",buffer2);
        strftime (buffer,6,"%M:%S",timeinfo2);
        printBigTime(buffer);
        wait(4.0);

    }
}
