/* michael@ruck.com märz 2015 v0.1*/
#include "Debounce.h"
#include "mbed.h"


Debounce::Debounce(PinName pin, uint16_t delay, PinMode pull) : _pin(pin)
{
    _delay=delay;
    _timer.start();
    _pin.mode(pull);
}

uint8_t Debounce::read()
{
    static uint8_t encbutton_state=1, encbutton_state_old, encbutton;
    static int systime, systime_old;

    encbutton_state = _pin.read();
    systime=_timer.read_ms();
    if((encbutton_state != encbutton_state_old) && (systime > systime_old+_delay)) {
        encbutton=encbutton_state;
        systime_old=systime;
        //printf("Button=%i\r\n", encbutton);
    }
    encbutton_state_old=encbutton_state;
    return encbutton;
}
