#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "DS18S20.h"
#include "DS18B20.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "OneWireDefs.h"

#define THERMOMETER DS18B20

// For Speaker Thread
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
AnalogOut DACout(p18);      // speaker
wave_player waver(&DACout); // wav player
AnalogIn liquidlevel(p17);
Serial blue(p28,p27);
uLCD_4DGL uLCD(p9,p10,p11);
DigitalOut myLED(LED1);
THERMOMETER device(true, true, false, p24);
Mutex mutex;
int is_Full = 0;
int is_Empty = 0;
int is_Drink = 0;

int count = 0;

float level;
float deltaWaterLevel;
float prevWaterLevel = 1.0;

float temp;

void speaker_thread(void const *args)
{
    Thread::wait(2000);
    FILE *wave_file;
    while(1)
    {
        while(is_Full != 1 && is_Empty != 1 && is_Drink != 1)
        {
            Thread::yield();
        }
        
        if (is_Full==1)
        {
            // play wav file
            wave_file=fopen("/sd/water_full.wav","r");
            waver.play(wave_file);
            fclose(wave_file);
            
            mutex.lock();
            is_Full = 2;
            mutex.unlock();
        }
        else if (is_Empty==1)
        {
            // play wav file
            wave_file=fopen("/sd/water_empty.wav","r");
            waver.play(wave_file);
            fclose(wave_file);
            
            mutex.lock();
            is_Empty = 2;
            mutex.unlock();
        }
        else if (is_Drink==1)
        {
            // play wav file
            wave_file=fopen("/sd/please_drink_now.wav","r");
            waver.play(wave_file);
            fclose(wave_file);
            
            mutex.lock();
            is_Drink = 0;
            mutex.unlock();
        }
    }
}

void bluetooth_thread(void const *args)
{
    while(true)
    {
        while(blue.writeable())
        {
            blue.printf("Water Level: %3.0f%%\n", level*100);
            while (temp < 0)
            {
                temp = device.readTemperature();
            }
            blue.printf("Temperature: %2.1f C\n", temp);
            Thread::wait(4000);
        }
    }
}

void uLCD_thread(void const *args)
{
    Thread::wait(2000);
    while(1)
    {
        temp = device.readTemperature();
        uLCD.cls();
        uLCD.filled_rectangle(0,128-(128*level),64,128, BLUE);
        uLCD.locate(3,6);
        uLCD.printf("%3.0f%%", level*100);
        uLCD.locate(11,6);
        while (temp < 0)
        {
            temp = device.readTemperature();
        }
        uLCD.printf("%2.1f C", temp);
        Thread::wait(2000);
    }
}

void timer_thread(void const *args)
{
    while (1)
    {
        if (count == 1)
        {
            if (deltaWaterLevel < 0.2)
            { 
                mutex.lock();
                is_Drink = 1;
                mutex.unlock();
            }
            count = 0;
        }
        
        
        if (level < 0.7 )
        {
            mutex.lock();
            is_Full = 0;
            mutex.unlock();
        }
        else if (level > 0.4)
        {
            mutex.lock();
            is_Empty = 0;
            mutex.unlock();
        }
        Thread::wait(15000);
        count++;
    }
}

int main() {
     Thread t2(speaker_thread);
     Thread t3(bluetooth_thread);
     Thread t4(uLCD_thread);
     Thread t5(timer_thread);
    
    float reading;
    
    while(1) {
        reading = liquidlevel.read();
        while (!device.initialize());
        level = -1*(reading-.507)/(.507-.20);
        if (count == 0)
        {
            deltaWaterLevel = 0;
        }   
        
        if (prevWaterLevel - level >= 0.05)
        {
            deltaWaterLevel += prevWaterLevel - level;
        }
        
        // Checks Max and Min
        if (level > 1.0)
        {
            level = 1.0;
        }
        else if (level < 0)
        {
            level = 0;
        }
        
        // Checks Full and Empty Threshold
        if (level >= 0.9 && is_Full == 0)
        {
            mutex.lock();
            is_Full = 1;
            mutex.unlock();
        }
        else if (level <= 0.1 && is_Empty == 0)
        {
            mutex.lock();
            is_Empty = 1;
            mutex.unlock();
        }
        
        prevWaterLevel = level;
        Thread::wait(9000);
    }
}
