/* this file needs customization 
   according the target hardware
*/


#include "mbed.h"

extern "C" void rf_if_interrupt_handler(void);

#if defined(TARGET_K64F)
SPI spi(PTD2, PTD3, PTD1);
#elif defined(TARGET_NUCLEO_F401RE)
SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK);
#elif defined(TARGET_NUCLEO_F411RE)
SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK);
#else
/*  "SPI not defined for this platform" */
SPI spi(D11, D12, D13);
#endif

DigitalOut RF_CS(D10);
DigitalOut RF_RST(D5);
DigitalOut RF_SLP_TR(D7);
InterruptIn RF_IRQ(D9);

     
extern "C" void RF_IRQ_Init(void) {
    
    RF_IRQ.rise(&rf_if_interrupt_handler);
}

extern "C" void RF_RST_Set(int state) {
    RF_RST = state;
}

extern "C" void RF_SLP_TR_Set(int state) {
    RF_SLP_TR = state;
}

extern "C" void RF_CS_while_active(void) {
    
    while(!RF_CS);
}


extern "C" int spi_read(char addr) {
    
  // Select the device by seting chip select low
  RF_CS = 0;
  // Write the reg. address
  spi.write(addr);
  // write a dummy value to read the reg. value
  int val = spi.write(0x00);
  // Deselect the device
  RF_CS = 1;
  return val;
} 

extern "C" void spi_write(char addr, char val) {
    
  // Select the device by seting chip select low
  RF_CS = 0;
  // Write the reg. address
  spi.write(addr);
  // write the value to the addresses register
  spi.write(val);
  // Deselect the device
  RF_CS = 1;
}

extern "C" void RF_CS_Set(int state) {
    RF_CS = state;
}

extern "C" int spi_exchange(char value) {
    
  // write the value
  int val = spi.write(value);
    return val;
}
