#ifndef __DEBUG_H_
#define __DEBUG_H_

#include "mbed.h"

#include "nsdl_dbg.h"
#include "stdint.h"
    
extern "C" void debug_integer(uint8_t width, uint8_t base, int16_t n);
extern "C" int16_t debug_get(void);
extern "C" int8_t debug_put(uint8_t byte);
extern "C" void debug_send(uint8_t *str);
extern "C" void printf_array(uint8_t *ptr , uint16_t len);
extern "C" void printf_string(uint8_t *ptr , uint16_t len);
extern "C" void printf_ipv6_address(uint8_t *addr_ptr);
extern "C" int8_t debug_init(uint32_t speed, uint8_t io_conf);
extern "C" void debug_interrupt_handler(void);
extern "C" uint32_t debug_round(uint32_t value, uint32_t divider);

#define MEM_VALID(x) \
    int s##x=0;\
    int *h##x = new int [1];\
    std::printf("[stack]0x%08x\t[heap]0x%08x\t[memory avail]%d bytes \tLine: %d %s\r\n", &s##x, h##x, &s##x-h##x, __LINE__, __FILE__);\
    if (h##x > &s##x)\
    printf("collision\n");\
    else\
    delete [] h##x;\
    __nop()

#define debug_hex(y)    debug_integer(2, 16, y)
#define debug_int(y)    debug_integer(6, 10, y)

#endif // __DEBUG_H_