#include <stdint.h>
#include <string.h>
#include "platform.h"
#include "arm_hal_random.h"

void arm_random_module_init(void)
{
#if DEVICE_RNG
    rng_init();
#else
    // SW yet to be implemented
#endif
}

uint32_t arm_random_seed_get(void)
{
    uint32_t rn_number = 0;
#if DEVICE_RNG
    uint8_t number[4];
    rng_seed(number[0], 4);
    memcpy(rn_number, number, 4);
#else
    // SW yet to be implemented
#endif
    return rn_number;
}
