/**
 * @file    TempResource.h
 * @brief   mbed CoAP Endpoint
 * @author  Michael Koster
 * @version 1.0
 * @see
 *
 * Copyright (c) 2015
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __TEMP_RESOURCE_H__
#define __TEMP_RESOURCE_H__

// Base class
#include "DynamicResource.h"

// Temp Sensor connected to A0
AnalogIn temp_in(A0);

/** TempResource class
 */
class TempResource : public DynamicResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    TempResource(const Logger *logger,const char *name,const bool observable = false) : 
        DynamicResource(logger,name,"Temperature", SN_GRS_GET_ALLOWED,observable) {
    }

    /**
    Get the value of the Temperature Sensor
    @returns string containing the temperature value in Fahrenheit
    */
    virtual string get() {
        char temp_str[8];
        int B = 3975;
        memset(temp_str,0,8);
        float temp_read = temp_in.read();
        float resistance = (1-temp_read) * 10000/temp_read; //get the resistance of the sensor;
        float temp_c = 1/ ( logf(resistance/10000)/B + 1/298.15) -273.15;//convert to temperature via datasheet ;
        float temp_f = (1.8 * (double) temp_c) + 32;
        sprintf(temp_str,"%8.2f", temp_f);
        return string(temp_str);
    }
};

#endif // __TEMP_RESOURCE_H__
