/**
 * @file    PresenceResource.h
 * @brief   mbed CoAP Endpoint
 * @author  Michael Koster
 * @version 1.0
 * @see
 *
 * Copyright (c) 2015
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __PRES_RESOURCE_H__
#define __PRES_RESOURCE_H__

// Base class
#include "DynamicResource.h"

// Presence Sensor connected to D2
DigitalIn pres_in(D2);

/** TempResource class
 */
class PresenceResource : public DynamicResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    PresenceResource(const Logger *logger,const char *name,const bool observable = false) : 
        DynamicResource(logger,name,"Presence", SN_GRS_GET_ALLOWED,observable) {
    }

    /**
    Get the value of the Presence Sensor
    @returns string containing 1 for presence detected, 0 for no presence detected
    */
    virtual string get() {
        if(pres_in.read())
            return("1");
        else
            return("0");
    }
};

#endif // __PRES_RESOURCE_H__
