/**
 * @file    LuminanceResource.h
 * @brief   mbed CoAP Endpoint
 * @author  Michael Koster
 * @version 1.0
 * @see
 *
 * Copyright (c) 2015
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __LUMI_RESOURCE_H__
#define __LUMI_RESOURCE_H__

// Base class
#include "DynamicResource.h"

// Luminance Sensor connected to A0
AnalogIn lumi_in(A0);

/** LuminanceResource class
 */
class LuminanceResource : public DynamicResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    LuminanceResource(const Logger *logger,const char *name,const bool observable = false) : 
        DynamicResource(logger,name,"urn:X-ipso:sensor", SN_GRS_GET_ALLOWED,observable) {
    }

    /**
    Get the value of the Luminance Sensor
    @returns string containing the Luminance value 
    */
    virtual string get() {
        char lumi_str[6];
        memset(lumi_str,0,6);
        float lumi_read = lumi_in.read();
        sprintf(lumi_str,"%6.1f", (lumi_read * 100) );
        return string(lumi_str);
    }
};

#endif // __LUMI_RESOURCE_H__
