/**
 * @file    IlluminanceResource.h
 * @brief   mbed CoAP Endpoint
 * @author  Michael Koster
 * @version 1.0
 * @see
 *
 * Copyright (c) 2015
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __ILLUMI_RESOURCE_H__
#define __ILLUMI_RESOURCE_H__

// Base class
#include "DynamicResource.h"

// Luminance Sensor connected to A0
AnalogIn illumi_in(A0);

/** LuminanceResource class
 */
class IlluminanceResource : public DynamicResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    IlluminanceResource(const Logger *logger,const char *name,const bool observable = false) : 
        DynamicResource(logger,name,"urn:X-ipso:illuminance", SN_GRS_GET_ALLOWED,observable) {
    }

    /**
    Get the value of the illuminance Sensor
    @returns string containing the illuminance value 
    */
    virtual string get() {
        char illumi_str[6];
        memset(illumi_str,0,6);
        float illumi_read = illumi_in.read();
        sprintf(illumi_str,"%6.1f", (illumi_read * 100) );
        return string(illumi_str);
    }
};

#endif // __ILLUMI_RESOURCE_H__
