/**
 * @file    BuzzerResource.h
 * @brief   mbed CoAP Endpoint
 * @author  Doug Anson, Michael Koster
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BUZZER_RESOURCE_H__
#define __BUZZER_RESOURCE_H__


// Base class
#include "DynamicResource.h"

// our buzzer
DigitalOut buzzer_out(D4);

bool buzzing = 0;

/** BuzzerResource class
 */
class BuzzerResource : public DynamicResource
{

public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the Light resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    BuzzerResource(const Logger *logger,const char *name,const bool observable = false) : 
    DynamicResource(logger,name,"urn:X-IPSO:digital-output",SN_GRS_GET_ALLOWED|SN_GRS_PUT_ALLOWED,observable) {
    }
    /**
    Get the on/off value of buzzer
    @returns string containing the last setting
    */
    virtual string get() {
        if(buzzing) return ("1");
        else return ("0");
    }

    /**
    Set the value of the buzzer
    @param string input 0 for quiet, 1 for buzz
    */
    virtual void put(const string value) {
        if (value == "1") {
            buzzing = 1;
            buzzer_out = 1;
        }
        else if (value == "0"){
            buzzing = 0;
            buzzer_out = 0;
        }
    }
};

#endif // __BUZZER_RESOURCE_H__
