/**
 * @file    LedBarResource.h
 * @brief   mbed CoAP Endpoint Light resource supporting CoAP GET and PUT
 * @author  Doug Anson, Michael Koster
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __LEDBAR_RESOURCE_H__
#define __LEDBAR_RESOURCE_H__


// Base class
#include "DynamicResource.h"

// our LED Bar
#include "LED_Bar.h"

LED_Bar bar(D3, D2);

static char * leds = {"0000000000"}; //GGGGGGGGYR


void set_leds(char *leds)
{
int i;
    for (i=0; i<=9; i++) {
        if(leds[i] == '1')
            bar.setSingleLed((9-i),1);
        else if(leds[i] == '0')
            bar.setSingleLed((9-i),0);    
        }    
}

/** LedBarResource class
 */
class LedBarResource : public DynamicResource
{

public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the Light resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    LedBarResource(const Logger *logger,const char *name,const bool observable = false) : 
    DynamicResource(logger,name,"urn:X-ipso:actuator",SN_GRS_GET_ALLOWED|SN_GRS_PUT_ALLOWED,observable) {
    }

    /**
    Get the value of the LED bar
    @returns string containing either "0" (light off) or "1" (light on) for each LED segment
    */
    virtual string get() {
        return(leds);
    }

    /**
    Set the value of the LED bar
    @param string input the string containing "0" (light off) or "1" (light on) per segment
    */
    virtual void put(const string value) {
        if( sizeof(value) == sizeof(leds) ){
            leds = (char *)value.c_str();
            set_leds(leds);
        }
    }
};

#endif // __LEDBAR_RESOURCE_H__
