/**
 * @file    DhtTempResource.h
 * @brief   mbed CoAP Endpoint
 * @author  Michael Koster
 * @version 1.0
 * @see
 *
 * Copyright (c) 2015
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __DHT_TEMP_RESOURCE_H__
#define __DHT_TEMP_RESOURCE_H__

// Base class
#include "DynamicResource.h"

#include "DHT11.h"

/** DhtTempResource class
 */
class DhtTempResource : public DynamicResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    DhtTempResource(const Logger *logger,const char *name,const bool observable = false) : 
        DynamicResource(logger,name,"urn:X-ipso:temperature", SN_GRS_GET_ALLOWED,observable) {
    }

    /**
    Get the value of the Temperature Sensor
    @returns string containing the temperature value in Fahrenheit
    */
    virtual string get() {
        char temp_str[6];
        memset(temp_str,0,6);
        float temp_f = DHT_sensor.ReadTemperature(FARENHEIT);
        sprintf(temp_str,"%5.2f", temp_f);
        return string(temp_str);
    }
};

#endif // __DHT_TEMP_RESOURCE_H__
