/**
 * @file    DhtTempResource.h
 * @brief   mbed CoAP Endpoint
 * @author  Michael Koster
 * @version 1.0
 * @see
 *
 * Copyright (c) 2015
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __DHT_HUMI_RESOURCE_H__
#define __DHT_HUMI_RESOURCE_H__

// Base class
#include "DynamicResource.h"

#include "DHT11.h"

/** DhtTempResource class
 */
class DhtHumiResource : public DynamicResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    DhtHumiResource(const Logger *logger,const char *name,const bool observable = false) : 
        DynamicResource(logger,name,"urn:X-ipso:humidity", SN_GRS_GET_ALLOWED,observable) {
    }

    /**
    Get the value of the Humidity Sensor
    @returns string containing the humidity value
    */
    virtual string get() {
        char humi_str[6];
        memset(humi_str,0,6);
        float humidity = DHT_sensor.ReadHumidity();;
        sprintf(humi_str,"%5.2f", humidity);
        return string(humi_str);
    }
};

#endif // __DHT_HUMI_RESOURCE_H__
