/**
 * @file    ButtonResource.h
 * @brief   mbed CoAP Endpoint
 * @author  Michael Koster
 * @version 1.0
 * @see
 *
 * Copyright (c) 2015
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BUTTON_RESOURCE_H__
#define __BUTTON_RESOURCE_H__

// Base class
#include "DynamicResource.h"

// Push Button connected to D3
DigitalIn button_in(D3);

/** ButtonResource class
 */
class ButtonResource : public DynamicResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    ButtonResource(const Logger *logger,const char *name,const bool observable = false) : 
        DynamicResource(logger,name,"urn:X-ipso:digital-input", SN_GRS_GET_ALLOWED,observable) {
    }

    /**
    Get the value of the Button 
    @returns string containing 1 for button depressed or 0 for button not depressed
    */
    virtual string get() {
        if(button_in.read())
            return("1");
        else
            return("0");
    }
};

#endif // __BUTTON_RESOURCE_H__
