// IPSO Prototype Rain sensor resource implementation

#include "mbed.h"
#include "nsdl_support.h"

#define RAIN_RES_ID    "3300/1/5700"
#define RAIN_RES_RT    "urn:X-mbed:rain"

extern Serial pc;
uint8_t rain_max_age = 0; 
uint8_t rain_content_type = 50;

float rain_reading;
char rain_string[6];

/* Only GET method allowed */
static uint8_t rain_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        sprintf(rain_string,"%2.2f", rain_reading);
        pc.printf("rain: %s\r\n", rain_string);

        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(rain_string);
        coap_res_ptr->payload_ptr = (uint8_t*)rain_string;
        
        coap_res_ptr->content_type_ptr = &rain_content_type;
        coap_res_ptr->content_type_len = sizeof(rain_content_type);
        
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)nsdl_alloc(sizeof(sn_coap_options_list_s));
        if(!coap_res_ptr->options_list_ptr)
            {
            pc.printf("cant alloc option list for max-age\r\n");
            coap_res_ptr->options_list_ptr = NULL; //FIXME report error and recover
            }
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->max_age_ptr = &rain_max_age;
        coap_res_ptr->options_list_ptr->max_age_len = sizeof(rain_max_age);

        sn_nsdl_send_coap_message(address, coap_res_ptr);
        nsdl_free(coap_res_ptr->options_list_ptr);
        coap_res_ptr->options_list_ptr = NULL;
        coap_res_ptr->content_type_ptr = NULL;// parser_release below tries to free this memory

    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);

    return 0;
}

int create_rain_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(RAIN_RES_ID)-1, (uint8_t*)RAIN_RES_ID, sizeof(RAIN_RES_RT)-1, (uint8_t*)RAIN_RES_RT, 0, &rain_resource_cb, (SN_GRS_GET_ALLOWED));
    return 0;
}