// IPSO Prototype gas sensor resource implementation

#include "mbed.h"
#include "nsdl_support.h"

#define GAS_RES_ID    "3300/0/5700"
#define GAS_RES_RT    "urn:X-mbed:gas-sensor"

extern Serial pc;
uint8_t gas_max_age = 0; 
uint8_t gas_content_type = 50;

AnalogIn gasSensor(A0);
int gas_percent;
char gasPctString[5];

/* Only GET method allowed */
static uint8_t gas_sensor_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        gas_percent = gasSensor.read() * 100;
        sprintf(gasPctString,"%d", gas_percent);
        pc.printf("gas percent %s\r\n", gasPctString);

        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(gasPctString);
        coap_res_ptr->payload_ptr = (uint8_t*)gasPctString;
        
        coap_res_ptr->content_type_ptr = &gas_content_type;
        coap_res_ptr->content_type_len = sizeof(gas_content_type);
        
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)nsdl_alloc(sizeof(sn_coap_options_list_s));
        if(!coap_res_ptr->options_list_ptr)
            {
            pc.printf("cant alloc option list for max-age\r\n");
            coap_res_ptr->options_list_ptr = NULL; //FIXME report error and recover
            }
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->max_age_ptr = &gas_max_age;
        coap_res_ptr->options_list_ptr->max_age_len = sizeof(gas_max_age);

        sn_nsdl_send_coap_message(address, coap_res_ptr);
        nsdl_free(coap_res_ptr->options_list_ptr);
        coap_res_ptr->options_list_ptr = NULL;
        coap_res_ptr->content_type_ptr = NULL;// parser_release below tries to free this memory

    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);

    return 0;
}

int create_gas_sensor_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(GAS_RES_ID)-1, (uint8_t*)GAS_RES_ID, sizeof(GAS_RES_RT)-1, (uint8_t*)GAS_RES_RT, 0, &gas_sensor_resource_cb, (SN_GRS_GET_ALLOWED));
    return 0;
}