// Light resource implementation

#include "mbed.h"
#include "nsdl_support.h"
#include "LEDbar.h"
#include "LED_Bar.h"

#define LEDBAR_RES_ID    "11101/0/5901"
#define LEDBAR_RES_RT    "urn:X-mbed:LEDbar"

extern Serial pc;
char leds[] = {"0000000000"}; //GGGGGGGGYR

LED_Bar bar(D7, D6);

uint8_t ledbar_max_age = 0; 
uint8_t ledbar_content_type = 0;

void set_leds(char *leds)
{
int i;
    for (i=0; i<=9; i++) {
        if(leds[i] == '1')
            bar.setSingleLed((9-i),1);
        else if(leds[i] == '0')
            bar.setSingleLed((9-i),0);    
        }    
}


/* Only GET and PUT method allowed */
static uint8_t LEDbar_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;

    //pc.printf("LED Strip callback\r\n");

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        coap_res_ptr->payload_len = strlen(leds);
        coap_res_ptr->payload_ptr = (uint8_t*)leds;
        
        coap_res_ptr->content_type_ptr = &ledbar_content_type;
        coap_res_ptr->content_type_len = sizeof(ledbar_content_type);
        
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)nsdl_alloc(sizeof(sn_coap_options_list_s));
        if(!coap_res_ptr->options_list_ptr)
            {
            pc.printf("cant alloc option list for max-age\r\n");
            coap_res_ptr->options_list_ptr = NULL; //FIXME report error and recover
            }
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->max_age_ptr = &ledbar_max_age;
        coap_res_ptr->options_list_ptr->max_age_len = sizeof(ledbar_max_age);

        sn_nsdl_send_coap_message(address, coap_res_ptr);
        nsdl_free(coap_res_ptr->options_list_ptr);
        coap_res_ptr->options_list_ptr = NULL;
        coap_res_ptr->content_type_ptr = NULL;// parser_release below tries to free this memory

    }
    else if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_PUT)
    {
        //pc.printf("PUT: %d bytes\r\n", received_coap_ptr->payload_len);
        if(received_coap_ptr->payload_len == 10)
        {
            memcpy(leds, (char *)received_coap_ptr->payload_ptr, received_coap_ptr->payload_len);

            leds[received_coap_ptr->payload_len] = '\0';
            pc.printf("PUT: %s\r\n",leds);

            //call LED strup update function here
            set_leds(leds);

            coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
            sn_nsdl_send_coap_message(address, coap_res_ptr);
        }
    }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    return 0;
}

int create_LEDbar_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(LEDBAR_RES_ID)-1, (uint8_t*)LEDBAR_RES_ID, sizeof(LEDBAR_RES_RT)-1, (uint8_t*)LEDBAR_RES_RT, 0, &LEDbar_resource_cb, (SN_GRS_GET_ALLOWED | SN_GRS_PUT_ALLOWED));
    set_leds("0000000000");
    return 0;
}