// IPSO Presence sensor resource implementation

#include "mbed.h"
#include "rtos.h"
#include "nsdl_support.h"

#define PRESENCE_RES_ID    "3302/0/5500"
#define PRESENCE_RES_RT    "urn:X-ipso:presence"

extern Serial pc;
uint8_t presence_max_age = 0; 
uint8_t presence_content_type = 50;

static uint8_t pres_obs_number = 0;
static uint8_t *pres_obs_token_ptr = NULL;
static uint8_t pres_obs_token_len = 0;

DigitalIn presenceSensor(D2);
uint8_t presence = 0;
uint8_t last_presence = 0;
char presenceString[1];

static void pres_observe_thread(void const *args)
    {
    while (true)
        {
        wait(.1);
        presence = presenceSensor.read();
        if((presence != last_presence) && pres_obs_number != 0 && pres_obs_token_ptr != NULL)
            {
            last_presence = presence;
            pc.printf("presence: %d\r\n", presence);
            pres_obs_number++;
            sprintf(presenceString,"%d", presence);            
            if(sn_nsdl_send_observation_notification(pres_obs_token_ptr, pres_obs_token_len, (uint8_t*)presenceString, strlen(presenceString), &pres_obs_number, 1, COAP_MSG_TYPE_NON_CONFIRMABLE, 0) == 0)
                pc.printf("Presence observation sending failed\r\n");
            else
                pc.printf("Presence observation\r\n");
            }
        }
    }


/* Only GET method allowed */
static uint8_t presence_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    presence = presenceSensor.read();
    sprintf(presenceString,"%d", presence);
    pc.printf("presence callback\r\n");
    pc.printf("presence state %s\r\n", presenceString);

    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
        {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);
   
        coap_res_ptr->payload_len = strlen(presenceString);
        coap_res_ptr->payload_ptr = (uint8_t*)presenceString;
        
        coap_res_ptr->content_type_ptr = &presence_content_type;
        coap_res_ptr->content_type_len = sizeof(presence_content_type);
        
        coap_res_ptr->options_list_ptr = (sn_coap_options_list_s*)nsdl_alloc(sizeof(sn_coap_options_list_s));
        if(!coap_res_ptr->options_list_ptr)
            {
            pc.printf("cant alloc option list\r\n");
            coap_res_ptr->options_list_ptr = NULL; //FIXME report error and recover
            }
        memset(coap_res_ptr->options_list_ptr, 0, sizeof(sn_coap_options_list_s));
        coap_res_ptr->options_list_ptr->max_age_ptr = &presence_max_age;
        coap_res_ptr->options_list_ptr->max_age_len = sizeof(presence_max_age);
        
        if(received_coap_ptr->token_ptr)
            {
            pc.printf("Token included\r\n");
            if(pres_obs_token_ptr)
                {   
                free(pres_obs_token_ptr);
                pres_obs_token_ptr = 0;
                }
            pres_obs_token_ptr = (uint8_t*)malloc(received_coap_ptr->token_len);
            if(pres_obs_token_ptr)
                {
                memcpy(pres_obs_token_ptr, received_coap_ptr->token_ptr, received_coap_ptr->token_len);
                pres_obs_token_len = received_coap_ptr->token_len;
                }
            }

        if(received_coap_ptr->options_list_ptr->observe)
            {
            coap_res_ptr->options_list_ptr->observe_ptr = &pres_obs_number;
            coap_res_ptr->options_list_ptr->observe_len = 1;
            pres_obs_number++;
            }
 
        sn_nsdl_send_coap_message(address, coap_res_ptr);
        nsdl_free(coap_res_ptr->options_list_ptr);
        coap_res_ptr->options_list_ptr = NULL;
        coap_res_ptr->content_type_ptr = NULL;// parser_release below tries to free this memory
        }

    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);

    return 0;
}

int create_IPSO_presence_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    static Thread exec_thread(pres_observe_thread);

    nsdl_create_dynamic_resource(resource_ptr, sizeof(PRESENCE_RES_ID)-1, (uint8_t*)PRESENCE_RES_ID, sizeof(PRESENCE_RES_RT)-1, (uint8_t*)PRESENCE_RES_RT, 1, &presence_resource_cb, (SN_GRS_GET_ALLOWED));
    return 0;
}