#include "mbed.h"

DigitalIn button(p17); // Sets input to pin 17
DigitalOut led1(LED1); // defines the first output to LED1
DigitalOut led2(LED2); // defines the second output to LED2
Serial pc(USBTX,USBRX);
int counter; // defines an integer to counter
int x; // defines an integer to x

int main()
{
    while(1) {
        x=button.read(); // "x" is equal to 1 or 0, depending on the state of the button
        if(counter>=10) { // when the integer "counter" is greater than or equal to 10, LED1 turns on
            led1=1;
        } else { // if the integer "x" is less than 10, LED1 is off
            led1=0;
        }
        if (x==1) { // if "x" equals one, LED2 turns on and off at one second frequency
            led2=1;
            wait(1);
            led2=0;
            wait(1);
        } else { // if "x" doesn't equal one (i.e. it equals zero), LED2 turns on and off at a 0.3 second frequency
            led2=1;
            wait(0.3);
            led2=0;
            wait(0.3);
        }
        if (button.read() != x) { // for every change in the button's state, 1 is added to the integer "counter"
            counter=counter+1;
            pc.printf("Instance: %i\r\n", counter);

        }
    }
}