//Blinks LED2 every 200ms and LED3 every 300ms using two Ticker objects and turns LED1 on and off using a hardware interrupt.
//Created: M. Antonucci 10/13/2022(Modified S. Licht code)
#include "mbed.h"
Serial pc(USBTX, USBRX); //tx, rx
Ticker tickerLED2;  //create ticker object
Ticker tickerLED3;  //create ticker object
Timer debounce;   //create timer object
Timer elapsed;   //create timer object
InterruptIn button(p17);   //setup interrupt for the button
DigitalOut LEDOut1(LED1);   //identify the leds being used
DigitalOut LEDOut2(LED2);
DigitalOut LEDOut3(LED3);

void changeLED2()  //the function that will be called by the ticker object.
{
    LEDOut2 = !LEDOut2;
}

void changeLED3()  //the function that will be called by the ticker object.
{
    LEDOut3 = !LEDOut3;
}

void changeLED1()   //the function that will be called by the interrupt object.
{
    LEDOut1 = !LEDOut1;
    pc.printf("%f\r\n",elapsed.read());
}

void toggle(void);   //referencing the 'void' that is after the main code

int main()
{
    debounce.start();   //start the debounce timer
    elapsed.start();   //starts the code run time timer
    tickerLED2.attach(&changeLED2,0.2); //the address of the function to call
    //and the interval in seconds between
    //calls to that function
    tickerLED3.attach(&changeLED3,0.3);

    button.fall(&changeLED1);   //When button voltage falls, the LED changes

    while(1) {
        //wait(.1);
        //wait(.1);
        //wait(.1);
        //the main loop is spinning every 300ms, but the LED needs to go faster!
    } //while

}

int db = 0;   //defines a variable for debounce

void toggle() {
    db = debounce.read_ms();   //defines db as the value of the debounce timer
    if (db>5)
    LEDOut1 = !LEDOut1;   //stops the LED from switching if the debounce timer is too low
    pc.printf("%i\r\n",db);   //prints db
    debounce.reset();   //reset the debounce timer each time the button is pressed with a gap of more than 5ms 
}