#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include "cli.hpp"
#include "file_manager.hpp"

#define SD      1
#define MII     0
 
#if SD + MII == 2
    #error "Wybierz tylko jeden przyklad."
#endif

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
Serial pc(USBTX, USBRX);
DigitalOut led(LED1);
EthernetInterface eth;

int main() {
#if MII
    pc.printf("Ethernet example\r\n");
    eth.init(); //Use DHCP
    eth.connect();
    pc.printf("IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketConnection sock;
    sock.connect("mbed.org", 80);
    
    char http_cmd[] = "GET /media/uploads/mbed_official/hello.txt HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
      
    sock.close();
    
    eth.disconnect();
    
    while(1) {}
#elif SD
    cli_sd cli;
    file_manager fm;
    char cmd;
    
    cli.welcome();
    cli.print_help();
    
    while(1) 
    {
        cmd = cli.get_cmd();
        
        switch(cmd)
        {
//            case 'm':
//                break;
            case 'p':
                fm.set_path();
                break;
            case 'w':
                fm.write_to_file();
                break;
//            case 'a':
//                fm.append_to_file();
//                break;
            case 'r':
                fm.read_file();
                break;
            case 'h':
                cli.print_help();
                break;
            default:
                pc.printf("Error.\r\n");         // should never enter this
                break;
        }
    }
#endif
}